// 

_approx := funcenv(() -> procname(args()),
		   builtin(1097, 400, " ~= ", "_approx")):

_approx::Content := stdlib::genOutFunc("Capprox", 2, infinity):

_approx::type := "_approx":

_approx::bool :=
proc(a,b)
local fa, fb;
begin
  fa := float(a);
  fb := float(b);
  if {domtype(fa), domtype(fb)} minus {DOM_FLOAT, DOM_COMPLEX} <> {} then
    return(UNKNOWN);
  end;
  if iszero(fa) then
    return(bool(specfunc::abs(fb)<10^(-DIGITS)));
  elif iszero(fb) then
    return(bool(specfunc::abs(fa)<10^(-DIGITS)));
  else
    // use exact arithmetic for computing (b-a)/a, then float!
    return(bool(specfunc::abs(float((b-a)/a))<10^(-DIGITS)));
  end;
end:

// overload _plus
// TODO: Do something useful here!
_approx::_plus :=
() -> hold(_plus)(args()):

// overload _mult
// TODO: Do something useful here!
_approx::_mult :=
() -> hold(_mult)(args()):

// overload _power
// TODO: Do something useful here!
_approx::_power :=
() -> hold(_power)(args()):



`~=` := _approx:
