//   

// (ident, prop, Op) verknupft die Eigenschaften von ident Op prop
assumeAlso:= proc( ident, prop=FAIL )
    local inds, s,
      argn;
  begin
    if testargs() then
      argn := args(0);
      /* Erwartet sind 1 bis 2 Argumente */
      if argn=0 then error( "No argument given" ); end_if;
      if argn>2 then error( "Wrong number of arguments" ); end_if;

      /* Bei mehr als einem Argument oder wenn erstes Argument nicht Bedingung */
      if argn>1 or not testtype(args(1), Type::Condition) then
        if not testtype(args(argn), Type::Property) and not testtype(args(argn), Type::Set) and
            not ( domtype(args(argn)) = DOM_EXPR and
                    misc::maprec(args(argn), {"NRange", "Prop",
                                              "Rel", "Complex", "Residue"} = TRUE) = TRUE )
          and not testtype( args(argn), Type::Set ) then
            if argn=1 then
              error( "First argument must be a condition" );
            else
              error("Second argument must be a property");
            end_if;
        end_if;
        if argn>1 and not testtype(args(1), Type::Union( Type::Arithmetical, Type::ListOf(Type::Arithmetical), Type::SetOf(Type::Arithmetical) )) then
          error( "First argument must be an arithmetical expression (or a set/list of arithmetical expression)" );
        end_if;
      end_if;
    end_if;

  inds := property::freeIndets([args()]);
  s := select( inds, X->properties(X)<>FAIL );
  inds := _union( op( map( s, X->properties(X)[5] ) ), inds );

  traperror( context( hold(_save)( op(inds) ) ) );

  return( property::_assume(args(), _and) );
end_proc:
