// 

/*
   autoload -- an advanced loadproc

   autoload(somelib::function) causes the same effect as
   somelib::function := loadproc(somelib::function, "SOMELIB", "function"),
   handling nested libraries in the obvious way.

   To think about: Additional arguments, should they denote
   the filename to use or regarded as additional args to loadproc,
   i.e., a function to call after loading the file?
*/

stdlib::standardFilename :=
proc(p)
  option hold, noDebug;
  local prefix, file, t;
begin
  if domtype(p) = DOM_VAR then
    p := context(p);
  end_if;
  case domtype(p)
    of DOM_IDENT do
      prefix := "STDLIB/";
      file := expr2text(p);
      break;
    of DOM_EXPR do
      if op(p, 0) = hold(slot) then
	file := op(p, 2);
	t := op(p, 1);
	prefix := "";
	while op(t, 0) = hold(slot) do
	  prefix := stringlib::upper(op(t,2)).stdlib::PathSep.prefix;
	  t := op(t, 1);
	end_while;
	case t
	  of hold(Dom) do
	    prefix := "DOMAINS".stdlib::PathSep."DOMAIN".
		     stdlib::PathSep.prefix;
	    break;
	  of hold(Cat) do
	    prefix := "DOMAINS".stdlib::PathSep."CATEGORY".
		     stdlib::PathSep.prefix;
	    break;
	  of hold(Ax) do
	    prefix := "DOMAINS".stdlib::PathSep."AXIOM".
		     stdlib::PathSep.prefix;
	    break;
	  of hold(transform) do
	    prefix := "TRANS".stdlib::PathSep.prefix;
	    break;
	  otherwise
	    prefix := stringlib::upper(expr2text(t)).
		     stdlib::PathSep.prefix;
	end_case;
	break;
      end_if;
      // else fall through
    otherwise
      error("expecting an identifier or a slot expression");
  end_case;
  [prefix, file];
end_proc:
  
autoload :=
proc(p)
  option hold, noDebug;
  local prefix, file;
begin
  [prefix, file] := context(hold(stdlib::standardFilename)(p));
  
  context(hold(_assign)(p,
			hold(loadproc)(p, prefix, file)));
end_proc:

autoloadLibrary :=
proc(p)
  option hold, escape, noDebug;
  local libpath, nam, prefix, file, lib, resolved, FAILentries;
begin
  nam := context(hold(expr2text)(hold(hold)(p)));
  lib := newDomain(nam);
  lib::Name := nam;
  [prefix, file] := context(hold(stdlib::standardFilename)(hold(slot)(p, "x")));
  // for the benefit of prog::check:
  // first find the right entry in LIBPATH
  for libpath in LIBPATH do
    if stdlib::listDir(libpath.stdlib::PathSep.prefix) <> FAIL then
      break;
    end_if;
  end_for;
  lib::allAutoEntries :=  map(select(stdlib::listDir(libpath.stdlib::PathSep.prefix),
                                     strmatch, ".\\.mu$"),
                              s -> s[1..-4]);
  
  if not contains(lib::allAutoEntries, "undefinedEntries") then
    lib::undefinedEntries := {};
  end_if;
  if not contains(lib::allAutoEntries, "interface") then
    lib::interface := {};
  end_if;
  
  FAILentries := {"exported", "Name", "evaluate", "posteval", "allEntries",
                  "whichEntry", "new_extelement", "create_dom_elem",
                  "Content", "eval", "domtype", "type", "slot", "expr2text",
                  "indets", "freeIndets", "bool", "length", "rectform", 
                  "contains",
                  "expose", "hastype", "maprec", "op", "nops", "subsop"} minus
               lib::allAutoEntries;
  
  map(FAILentries, x -> eval(hold(slot)(lib, x, FAIL)));
  
  // to avoid infinite recursions
  resolved := table();
  lib::make_slot := subsop(
  proc(l, n)
    local err;
    save _assign;
    option noDebug;
  begin
    if has(resolved, n) then
      return(FAIL);
    end_if;
    resolved[n] := UNKNOWN;
    sysassign(_assign, sysassign);
    err := traperror(read(prefix.n.".mu", Plain));
    if err=1028 and 
      strmatch(getlasterror()[2], "Error: Could not open \".*?\" \\[read]")=TRUE then
      error(expr2text(dom)." has no entry \"".n."\". Please check ?".expr2text(dom));
    end_if;
    if err <> 0 then
      lasterror();
    end_if;
    if not contains(dom, n) then
      error(expr2text(dom)."::".n." not defined in ".prefix.n.".mu");
    end_if;
    resolved[n] := TRUE;
    slot(dom, n);
  end, 6=context(hold(hold)(p)));
  context(hold(sysassign)(p, lib));
end_proc:

prog::setCheckedProtectedAssignments(autoloadLibrary, {hold(_assign)}):
