//   

// card(S)
//
//  returns the cardinality of the set S
//


card:= funcenv
(proc(x)
   name card;
 begin
   if args(0)=0 then
     error("card called without arguments")
   end_if;
   
   // overloading 
   if x::dom::card <> FAIL then
     return(x::dom::card(x))
   end_if;

   // use size-entry of domains if present

   if type(x)=DOM_DOMAIN and x::size <> FAIL then
     return(x::size)
   end_if;
 
   // arg. check

   if testargs() then
     if args(0) > 1 then
       error("Too many arguments")
     end_if;
     if not testtype(x, Type::Set) then
       error("Argument must be a set-theoretic expression")
     end_if
   end_if;

   case type(x)
     of DOM_SET do
       return(nops(x))
     of "_union" do
       if contains(map([op(x)], card), infinity) > 0 then
         return(infinity)
       end_if;
       // otherwise fall through and return unevaluated
       break
   end_case;
   procname(args())
 end_proc):

card::type  := "card":
card::print := "card":

card::Content := stdlib::genOutFunc("Ccard", 1):

card::TeX := (arg1, arg2, arg3) -> "\\#(".generate::tex(op(arg2), output::Priority::Noop).")":
