/*++
    coerce(x, T)

    x      : expression
    T      : a domain

    coerce(x, T) tries to convert x to an object of the domain type T.
    It first calls T::convert(x <,a1,...>) to do the conversion.
    If this fails, then x::dom::convert_to(x,T <,a1,...>) is called.

    If the conversion is not possible (or not implemented), then FAIL 
    is returned.
++*/
coerce:= proc(x,target)
    local o;
begin
    if args(0) <> 2 then
        error("expecting two arguments, an object and the target domain")
    elif domtype(target) <> DOM_DOMAIN then
        target:= domtype(target)
    end_if;

    if domtype(x) = target then return(x) end_if;

    if target::coerce <> FAIL then
        return(target::coerce(x))
    end_if;

    o:= target::convert(x);
    if o <> FAIL then 
        return(o)
    else
        o:= x::dom::convert_to(x, target);
        if o <> FAIL then
            return(o)
        end_if
    end_if;

    // x could not be converted to an object of type T!
    return( FAIL )
end_proc:

