/*++
   combine.mu

	combine  --  combine terms of the same algebraic structure

	combine(e <,options>) combines terms of the same algebraic
	structure.

	For expressions of type DOM_FUNC_ENV the function attribute
	"combine" will be called with the operands of expr.
	If such a function attribute does not exist the expression will
	be returned without changes.

   combine(e, p <, options>) calls combine::p(e) if such slot exists; 
   several slots may be passed as a list

++*/

combine :=
proc(e, p)
  local _t, options: DOM_TABLE, optiontypes: DOM_TABLE;
begin
  if args(0) = 0 then
    error("combine called without arguments")
  end_if;
  
    // is overloaded ? 
  if e::dom::combine <> FAIL then
    return( e::dom::combine(e,args(2..args(0))) )
  end_if;

  options:= combine::defaultOptions;
  
  optiontypes:= table(IgnoreAnalyticConstraints = DOM_BOOL);
  
  case args(0)
    of 1 do
      break
    otherwise
      if type(p)=DOM_LIST then
        for _t in p do
          e:= combine(e,_t, args(3..args(0)))
        end_for;
        return(e)
      elif type(p) = DOM_TABLE then
        options:= p
      elif traperror((_t:=slot(combine,expr2text(p))))=0 and
        _t <> FAIL then
        options:= prog::getOptions(3, [args()],  options, TRUE, optiontypes)[1];
        return(_t(e, options))
      else
        options:= prog::getOptions(2, [args()],  options, TRUE, optiontypes)[1];
      end_if
  end_case;

  case domtype(e)
    // default is to return e, thus we do not need to consider these cases 
    of DOM_POLY  do
      return( mapcoeffs(e, combine, options))
    of DOM_LIST  do
    of DOM_ARRAY do
    of DOM_SET   do
      return( map(e,combine, options))
    of DOM_EXPR  do
      _t:= op(e,0);
      p:= eval(_t);
      if domtype(p) = DOM_FUNC_ENV and
        (p:= slot(p, "combine")) <> FAIL then
        return( p(e, options))
      end_if;      
      return( stdlib::mapEvalChanges(e, combine, options) )
    of DOM_HFARRAY do
       return(e);
  end_case;
  e
end_proc:

combine:= funcenv(combine):
combine::print:= "combine":

combine::defaultOptions:= table(IgnoreAnalyticConstraints = FALSE):

// auxiliary methods
combine::combineExponents:= loadproc(combine::combineExponents, pathname("STDLIB", "COMBINE"), "combineExponents"):
combine::isSmall:= loadproc(combine::isSmall, pathname("STDLIB", "COMBINE"), "isSmall"):

// targets 
combine::sincos:= loadproc(combine::sincos, pathname("STDLIB", "COMBINE"), "COMBsincos"):
combine::arctan:= loadproc(combine::arctan, pathname("STDLIB", "COMBINE"), "COMBarctan"):
combine::exp:= loadproc(combine::exp, pathname("STDLIB", "COMBINE"), "COMBexp"):
combine::gamma:= loadproc(combine::gamma, pathname("STDLIB", "COMBINE"), "COMBgamma"):
combine::ln:= loadproc(combine::ln, pathname("STDLIB", "COMBINE"), "COMBln"):
combine::log:= loadproc(combine::log, pathname("STDLIB", "COMBINE"), "COMBlog"):
combine::_power:= loadproc(combine::_power, pathname("STDLIB", "COMBINE"), "COMB_power"):
combine::sinhcosh:= loadproc(combine::sinhcosh, pathname("STDLIB", "COMBINE"), "COMBsinhcosh"):
