/*++

det -- determinant of a matrix

Calls: det(A)
   
Parameters:
  A - a 2-dim array, an hfarray, or a matrix of category Cat::Matrix

Overloadable
   
++*/

det := proc(A)
begin
   if args(0) <> 1 then
      error("expecting one argument");
   end_if:
   if A::dom::det <> FAIL then
      return(A::dom::det(A));
   end_if:
   case domtype(A) 
   of DOM_ARRAY do
         if op(A, [0, 1]) <> 2 then
            error("expecting a matrix as a 2 dimensional array");
         end_if:
         if op(A, [0, 2, 2]) - op(A, [0, 2, 1]) <>
            op(A, [0, 3, 2]) - op(A, [0, 3, 1]) then
            error("expecting a square matrix");
         end_if:
         return(numeric::det(A, Symbolic)); 
   of DOM_HFARRAY do
         if op(A, [0, 1]) <> 2 then
            error("expecting a matrix as a 2 dimensional hfarray");
         end_if:
         if op(A, [0, 2, 2]) - op(A, [0, 2, 1]) <>
            op(A, [0, 3, 2]) - op(A, [0, 3, 1]) then
            error("expecting a square matrix");
         end_if:
         return(numeric::det(A));
   end_case;
   if A::dom::hasProp(Cat::Matrix)=TRUE then
      return(linalg::det(A));
   end_if:
   hold(det)(A);
end_proc:
det := funcenv(det):
det::Content := stdlib::genOutFunc("Cdeterminant", 1):
