//   
/*
      evalAt(f, x1=a1, .., xn=an)

      (or: f | (x1=a1, ..., xn=an) )

      substitutes x1=a1, .., xn=an in f

      f may also be a sequence


*/

evalAt:=
proc(f, subst)
  option hold;
  local i, noSetsOrLists: DOM_BOOL;
begin
  if args(0) < 2 then
     error("Wrong number of arguments");
  end_if:
  if args(0) > 2 then
    f:= context(f);
    for i from 2 to args(0) do
      f:= evalAt(f, context(args(i)))
    end_for;
    return(f)
  end_if;
  
  f:= context(f);
  subst:= {context(subst)};

  // denest
  repeat
    noSetsOrLists:= TRUE;
    subst:= map(subst,
                proc(eq)
                begin
                  case type(eq)
                    of "_equal" do
                      return(eq)
                    of DOM_SET do
                    of DOM_LIST do
                      noSetsOrLists:= FALSE;
                      return(op(eq))
                    otherwise
                      error("Equation expected")
                  end_case
                end_proc
                )
  until noSetsOrLists end_repeat;
  return(stdlib::evalAt(f, subst)) ;
end_proc:

evalAt := funcenv(evalAt,
                  proc(f)
                    local stripStr, str;
                  begin
                    stripStr := proc(str)
                                begin
                                  if str[1] <> "" and str[2] = str[4] then
                                    if str[1][1] = "\n" then
                                      str[1] := str[1][2..-1];
                                      str[6] := str[6] - 1
                                    elif str[1][1..2] = "\r\n" then
                                      str[1] := str[1][3..-1];
                                      str[6] := str[6] - 1
                                    end_if;
                                    str;
                                  else
                                    FAIL
                                  end_if
                                end:
                    
                      case nops(f)
                      of 0 do
                        return("evalAt()");
                      of 1 do
                        if PRETTYPRINT then
                          str := stripStr(strprint(All, op(f)));
                          if str = FAIL then
                            return(FAIL)
                          else
                            return(_outputSequence(stdlib::Exposed("evalAt"),
                                     stdlib::Exposed(
                                       output::fence("(", ")",
                                                     str[1], str[3], str[6]))))
                          end_if;
                          
                        else
                          return("evalAt(".expr2text(op(f)).")")
                        end_if;
                      of 2 do
                        return(subsop(f,
                                      0=funcenv(#, builtin(1100, 30, " | ", "evalAt")),
                                                Unsimplified));
                      otherwise
                        subsop(f, 0=stdlib::Exposed("evalAt"), Unsimplified)
                    end_case
                  end_proc):
                  
evalAt::Content := (Out, x) ->
                   if nops(x) <> 2 then
                     Out::stdFunc(x)
                   else
                     Out::Capply(Out::CevalAt, Out(op(x, 1)),
                                 Out(op(x, 2))):
                   end_if:


evalAt::type:= "evalAt":

evalAt::testtype:=
proc(x, T)
begin
  if T = Type::Arithmetical or T = Type::Set then
    testtype(op(x, 1), T)
  else
    FAIL
  end_if
end_proc:


evalAt::diff:= 
proc()
begin
  hold(diff)(args())
end_proc:  

diff::evalAt:=
proc(f:"diff", subst)
  local vars, dontsubst, dummy;
begin
  vars:= {op(f, 2..nops(f))};
  vars := map(vars, v -> if type(v)="_seqgen" then op(v, 1) else v end);
  [subst, dontsubst, dummy]:= split(subst,
                                    equ -> not contains(vars, op(equ, 1)));
  assert(dummy = {});
  if dontsubst = {} then
    eval(subs(f, subst, Unsimplified))
  else
    hold(evalAt)(eval(subs(f, subst, Unsimplified)), dontsubst)
  end_if
end_proc:

_seqgen::evalAt:= 
proc(s:"_seqgen", subst)
  local subst2;
begin
  // for $1..m, we may evaluate as usual
  if nops(s) <> 3 then
    map(s, evalAt, subst)
  else
    // f $ i=a..b is represented as _seqgen(f, i, a..b)
    // we do not substitute i in the first two operands
    subst2:= select(subst, equ -> op(equ, 1) <> op(s, 2));
    eval(hold(_seqgen)(evalAt(op(s, 1), subst2), op(s, 2), evalAt(op(s, 3), subst)))
  end_if
end_proc:  


_seqstep::evalAt:=
proc(s:"_seqstep", subst)
  local subst2;
begin
  if nops(s) <> 4 then
    map(s, evalAt, subst)
  else
    // f $ i=a..b step n is represented as _seqgen(f, i, a..b, n)
    // we do not substitute i in the first two operands
    subst2:= select(subst, equ -> op(equ, 1) <> op(s, 2));
    eval(hold(_seqstep)(evalAt(op(s, 1), subst2), op(s, 2), evalAt(op(s, 3), subst), evalAt(op(s, 4), subst)))
  end_if    
end_proc:  



`|` := evalAt:
