//    

// kg, 20/02/95 

/*++
expose(x) -- return the definition of x

x - expression
++*/

expose:= proc(f)
           local method;
         begin
           method := (domtype(f))::expose;
           if method <> FAIL then
             method(f)
           else
             f
           end_if
         end_proc:

DOM_FUNC_ENV::expose:= proc() begin expose(op(args(1), 1)) end_proc :

DOM_EXEC::expose:= proc() begin 
    hold(builtin)(op(args(1))) 
 end_proc :

DOM_DOMAIN::expose:=
proc(x)
  local t, xkey, sdom, categ, axi;
begin
  if x::expose <> FAIL and x <> DOM_DOMAIN then
    x::expose()
  else
    t :=  table(op(x));
    if contains(t, "constructor") then
      x::allEntries();
      t :=  table(op(x));
    end;
    sdom := t["super_domains"];
    if contains(t, "super_domains") and sdom <> [] then
      sdom := "\n  inherits ".expr2text(op(sdom))."\n";
    else
      sdom := "";
    end;
    categ := t["categories"];
    if contains(t, "categories") and categ <> [] then
      categ := "\n  category ".expr2text(op(categ))."\n";
    else
      categ := "";
    end;
    axi := t["axioms"];
    if contains(t, "axioms") and axi <> [] then
      axi := "\n  axioms ".expr2text(op(axi))."\n";
    else
      axi := "";
    end;
    xkey := t["key"];
    if not testtype(xkey, DOM_STRING) then
      xkey := expr2text(xkey);
    end;
    
    delete t["key"], t["make_slot"], t["axioms"], t["categories_idx"],
           t["categories"], t["super_domains"], t["closure"], t["constructor"];
    t := select(t, x -> op(x, 2) <> FAIL);
    
    stdlib::Exposed(_concat("domain ", xkey, "\n", sdom, categ, axi,
                             op(map([op(t)], x -> ("\n  ", op(x,1), " := ",
                                 _if(testtype(op(x, 2), DOM_PROC),
                                     DOM_PROC::print(op(x,2)),
                                     expr2text(op(x,2))), ";\n"))),
                             "end_domain"));
  end_if;
end_proc:

DOM_PROC::expose := p -> stdlib::Exposed(expr2text(p)):

DomainConstructor::expose := dc -> expose(op(dc, 1)):

// end of file 
