// 

/*++
   frandom -- random number generator of floats, uniformly
              distributed in [0,1].  Uses the kernel function
              stdlib::frandom.

   frandom() returns a DOM_FLOAT chosen as specified above

   frandom(integer) returns a generator returning floats as specified above
++*/

frandom := proc()
 local seed;
 option escape;
begin
  case args(0)
    of 0 do
      stdlib::frandom();
      break;
    of 1 do
      seed := args(1);
      if seed::dom <> DOM_INT and seed <> CurrentTime
        then error("illegal type of argument (integer or CurrentTime expected)");
      end_if;
            
      proc()
        local val;
      begin;
        [seed, val] := stdlib::frandom(seed);
        val;
      end_proc;
      break;
    otherwise
      error("zero or one argument(s) expected");
  end_case
end_proc:

frandom:= funcenv(frandom):
frandom::type:= "frandom":

