/*
  
  gcdex(A, B <,x>)
  gcdex(a, b, x)

  A, B - polynomials of the same type
  a, b - polynomial expressions in x
     x - variable  

  For univariate polynomials A(x), B(x), the third argument may be left out

  Returns: 

  polynomials G, S, T of the same type as A and B such that G = gcd(A, B) and S*A + T*B = G
  or, respectively,
  expressions g, s, t such that g = gcd(a, b) and s*a + t*b = g

*/

gcdex :=
proc(A, B, x)
begin
  if args(0)<2 or args(0)>=4 then
    error("Wrong number of arguments")
  end_if;

  if A::dom::gcdex <> FAIL then return(A::dom::gcdex(args())) end_if;
  if B::dom::gcdex <> FAIL then return(B::dom::gcdex(args())) end_if;
  
  case [bool(domtype(A) = DOM_POLY), bool(domtype(B) = DOM_POLY)]
  of [FALSE, FALSE] do
    if args(0) < 3 then 
      error("Either a variable must be given, ".
      "or input must consist of polynomials")
    end_if;    
    
    if testargs() then
      if not testtype(A, Type::PolyExpr([x])) or not testtype(B, Type::PolyExpr([x])) then
        error("Not a polynomial expression")
      end_if;  
    end_if;  
    
    return(gcdlib::gcdexExpr(A, B, x))
  of [TRUE, TRUE] do  
    // now A and B are polynomials
    if op(A,2..3)<>op(B,2..3) then
      error("Polynomial types differ")
    end_if;
    
    if args(0) = 2 then
      x:= op(A,2);
      if nops(x)<>1 then
        error("Polynomials must be univariate")
      end_if;
      x:= x[1];
    else 
      // convert multivariate polynomials into univariate ones
      A:= poly(A, [x], op(A, 3));
      B:= poly(B, [x], op(B, 3));
    end_if; 
    
    return(gcdlib::gcdexPoly(A, B, x)) 
  otherwise
    error("Either both or no argument must be polynomials")
  end_case 
end_proc:
  
  
// end of file
