/*++ ---------------- hasaccess.mu ---------------------
- stdlib::hasaccess("external_command")
  tests, if the given external_command is accessible or not. If so TRUE is
  returned, otherwise FALSE.
  Currently stdlib::hasaccess will only work for UNIX-systems, in all other cases
  FALSE is returned.                                       

Example:
>> stdlib::hasaccess("mupad");
                                       
++*/

/*
stdlib::hasaccess:=
  proc(s:DOM_STRING)
    //save shell;
  begin
    if domtype(shell)<>DOM_DOMAIN then module(hold(shell)) end_if;
    case sysname()
      of "UNIX" do
        //if system("(/bin/sh -c 'type ".s."') > /dev/null 2> /dev/null")=0
        if traperror(shell::system("/bin/sh -c 'type ".s."'"))=0 
          then TRUE
        else FALSE
        end_if; break;
      otherwise
        FALSE
    end_case
  end_proc:
*/

stdlib::hasaccess:=
  proc(s:DOM_STRING)
    local syscall;
  begin
    syscall:=external("shell","system");
    case sysname()
      of "UNIX" do
        //if system("(/bin/sh -c 'type ".s."') > /dev/null 2> /dev/null")=0
        if traperror(syscall("/bin/sh -c 'type ".s."'"))=0 
          then TRUE
        else FALSE
        end_if; break;
      //of "MS-DOS" do
        
      otherwise
        FALSE
    end_case
  end_proc:
