/*++

htranspose -- Hermitean transpose of a matrix

Calls: transpose(A)
   
Parameters:
  A - a 2-dim array, an hfarray, or a matrix of category Cat::Matrix

Overloadable
   
++*/

htranspose := proc(A)
local i, j;
begin
   if args(0) <> 1 then
      error("expecting one argument");
   end_if:
   if A::dom::htranspose <> FAIL then
      return(A::dom::htranspose(A));
   elif A::dom::transpose <> FAIL and
        A::dom::conjugate <> FAIL then
      return(A::dom::transpose(A::dom::conjugate(A)));
   end_if:
   case domtype(A) 
   of DOM_ARRAY do
         if op(A, [0, 1]) <> 2 then
            error("expecting a matrix as a 2 dimensional array");
         end_if:
         A:= map(A, conjugate);
         return(array(op(A, [0, 3]), op(A, [0, 2]),
                      [[A[i, j] $ i = op(A, [0, 2, 1]) .. op(A, [0, 2, 2])
                       ]        $ j = op(A, [0, 3, 1]) .. op(A, [0, 3, 2])])
               );
   of DOM_HFARRAY do
         if op(A, [0, 1]) <> 2 then
            error("expecting a matrix as a 2 dimensional hfarray");
         end_if:
         return(hfa::transpose(hfa::conjugate(A)));
   otherwise
         hold(htranspose)(A);
   end_case;
end_proc:

htranspose := funcenv(htranspose):
htranspose::Content := stdlib::genOutFunc("Chtranspose", 1):
