//     

/*++
    ifactor  --  return the integer factorization of an integer

    ifactor(n <,UsePrimeTab>)
    ifactor(PrimeLimit)

    i: DOM_INT

    The result of 'ifactor(n,...)' is an object of the domain
    type Factored (try ?Factored for details).

    With option 'UsePrimeTab', ifactor finds only prime numbers of 
    the system prime table.

    ifactor(PrimeLimit) returns an integer, the limit of the prime table. 
    The table contains all primes less than this limit. The default values 
    are: 1000000 under Unix, 300000 under MacOS and Windows. 

    Note: The kernel function stdlib::ifactor may be used, when the 
          factorization of n is needed only for immediate calculations.
++*/

ifactor:= proc(l)
begin
    if l::dom::ifactor <> FAIL then
        return(l::dom::ifactor(args()))
    elif domtype((l:= stdlib::ifactor(args()))) = DOM_LIST then
        l := Factored::create(l, "irreducible", Dom::Integer);
        // the factorization need not be irreducible when the option
        // UsePrimeTab is used and at least one factor in the
        // result exceeds the square of the PrimeLimit
        if has([args()], UsePrimeTab) and not _and(op(
             map(Factored::factors(l), _less, stdlib::ifactor(hold(PrimeLimit))^2)
           )) then
          l := Factored::setType(l, "unknown")
        end_if
    end_if;
    return(l)
end_proc:

ifactor:= funcenv(ifactor):
ifactor::type:= "ifactor":

