//   

/*
   _in - elementhood operator


   _in(x,S)
   infix notation: x in S

   mathematically equivalent to x \in S

*/



// the function _in is inert (like _less, _unequal, etc.)

_in:= funcenv
(
 proc(x, S: Type::Set)
   name _in;
 begin
   if testargs() then
     if args(0)<>2 then
       error("Wrong number of arguments")
     end_if
   end_if;
 procname(x, S)
end_proc,

 builtin(1097, 400, " in ", "_in" )):

_in::type :="_in":
_in::print:="_in":
_in::Content := stdlib::genOutFunc("Cin", 2):

_in::float:= (x, S) -> float(x) in float(S):


// _in::expand - tries to rewrite in using relations

_in::expand:=
proc(a)
  local i, res, x, S;
begin
  [x, S]:= [op(a)];
  if x::dom::_in <> FAIL then
    return(x::dom::_in(x,S))
  end_if;

  if S::dom::set2expr <> FAIL then
    return(S::dom::set2expr(S,x))
  end_if;

  case type(S)
    of DOM_SET do
      return(_or(x=i $i in S))
    of "solve" do
      if testtype(op(S, 1), Type::Boolean) then
        if traperror((res:= evalAt(op(S,1), op(S,2)=x))) <> 0 then
          return(FALSE)
        else
          return(res)
        end_if
      elif contains({DOM_LIST, DOM_SET}, type(op(S,1))) then
        break
      else
        if traperror((res:= evalAt(op(S,1),op(S,2)=x))=0) <> 0 then
          return(FALSE)
        else
          return(res = 0)
        end_if
      end_if
    of RootOf do
      if traperror((res:=evalAt(op(S,1)=0, op(S,2)=x))) <> 0 then
        return(FALSE)
      else
        return(res)
      end_if
    of "_union" do
      return(_or(expand(x in op(S,i), args(2..args(0))) $i=1..nops(S)))
    of "_intersect" do
      return(_and(expand(x in op(S,i), args(2..args(0))) $i=1..nops(S)))
    of "_minus" do
      return(expand(x in op(S,1), args(2..args(0))) and not
             expand(x in op(S,2), args(2..args(0))))
    of DOM_INTERVAL do
      return(x >= op(S,1) and x <= op(S,2))
  end_case;

  hold(_in)(x, S)
end_proc:


// _in::bool - determines the boolean evaluation of expressions of type "_in"
// simply applies bool to the result of expand(.. in ..)


_in::bool:=
proc(x, S)
  local X;
begin
  // special case (faster than expanding)
  if type(S)=DOM_SET then
    contains(S, x)
  else
    if (X:= expand(x in S)) <> hold(_in)(x, S) then
      bool(X)
    elif S::dom::contains <> FAIL then
      X:= S::dom::contains(S, x);
      if X=TRUE or X=FALSE then
        X
      else
        error("contains method does not return TRUE or FALSE")
      end_if
    else
      error("cannot evaluate to boolean")
    end_if
  end_if
end_proc:


_in::simplify:= a -> map(a, simplify):

// _in::TeX for nicer TeX output

_in::TeX:= (arg1, arg2, arg3) ->
           generate::TeXoperator("\\in ", arg3,
                                 output::Priority::Relation, op(arg2)):
