/*++
	int -- integration

	int(f,x)
	int(p <, ... >)
	int(f,x=a..b)
	int(f,x=a..b, options)

	f - expression or domain
	x - identifier
	p - piecewise defined function or domain element

        currently as options are allowed:
           - PrincipalValue
           - Continuous

	This is merely a front end for indefinite integration via intlib::int,
	and definite via intlib::defInt.
++*/

int:= funcenv(
proc(f, x=null())
  name int;
  local integral, xx, a, b, prop, unevaluated_int, options;
  // we *need* to make assumptions based on the integration range
  option hold;
begin
  if args(0)=0 then error("No argument given") end_if;

  options := intlib::getOptions(context(args(3..args(0))));

  x := context(x);
  if type(x) = "_equal" and type(rhs(x)) = "_range" then
    xx:=op(x,1);
    if domtype(xx) <> DOM_IDENT then
      error("can only integrate w.r.t. identifiers");
    end_if;
    a:=op(op(x,2),1);
    b:=op(op(x,2),2);
    if protected(xx) <> None then
      userinfo(1, "".xx." is protected, can't do assumptions early on");
    else
      if is(a <= b) = UNKNOWN and intlib::printWarningsFlag and options[NoWarning]<>TRUE then
        warning("Cannot decide if ".expr2text(a <= b).", will temporarily assume it is true.");
      end_if;
      prop:=Dom::Interval([a,b]);
      if type(prop)=Dom::Interval or prop=R_ then
        if property::hasprop(xx) then
          if intlib::printWarningsFlag and options[NoWarning]<>TRUE then
            warning("While integrating, we will assume ".strprint(NoNL, xx).
                    " has property ".strprint(NoNL, prop).
                    " instead of given property ".strprint(NoNL, getprop(xx)).".");
          end_if;
          assume(xx in prop);
        else
          assume(xx, Type::Interval([a,b]), _and);
        end_if;
      end_if;
    end_if;
  end_if;

  f := hold(hold)(context(f)); // hold, to avoid repeated limit-evaluations in the next two if-clauses

  if testargs() and has(context([args()]),FAIL) then
    error("illegal argument(s)")
  end_if;

  if has(context([args()]), undefined) then
    return(undefined);
  end_if;

  assert(op(f, 0) = hold(hold));
  f := op(f);

  if f::dom::int <> FAIL then
    return(f::dom::int(f, x, context(args(3..args(0)))));
  elif domtype(f) = DOM_EXPR and domtype(eval(op(f, 0)))=DOM_FUNC_ENV and
    slot(eval(op(f,0)), "int") <> FAIL then
    return(slot(eval(op(f,0)), "int")(f, x, context(args(3..args(0)))));
  elif testtype(f,Type::Arithmetical)=FALSE then
    error("Illegal integrand")
  end_if;

  // now f is of type DOM_EXPR
  if args(0)=1 then
      error("Second argument is missing")
  end_if;

  if testtype(x, "_exprseq") then
    options := intlib::getOptions(x[2..-1], options);
    x := op(x, 1);
  end_if;

  if domtype(x)=DOM_IDENT then
    // indefinite integration
    integral := hold(int)(f, x, context(args(3..args(0))));
    traperror((integral := intlib::int(f,x,options)));
    integral := subs(integral, hold(intlib::frozenInt)=hold(int), Unsimplified);
	  // does the result contain an integral w.r.t. x?
    unevaluated_int := FALSE;
    if domtype(integral) <> piecewise or
      domtype(piecewise::disregardPoints(integral)) <> piecewise then
      misc::maprec(piecewise::disregardPoints(integral),
        {"int"} = (i -> (if op(i, [2, 1])=op(x, 1) then unevaluated_int := TRUE; end; i)));
    end_if;
    if unevaluated_int and not options[hold(AlwaysExtractIntegrableParts)]=TRUE and
	    intlib::Simplify::defaultValuation(integral) >
	    //3*intlib::Simplify::defaultValuation([f, x]) + 200 then
	      100 + intlib::Simplify::defaultValuation(hold(int)(f, x)) then
	      return(hold(int)(f, x, intlib::printOptions(options)));
	  end_if;
    return(integral);
  else
     if type(x)= "_equal" and type(op(x, 2)) = "_range" then
       // definite integration
       if testargs() then intlib::xrngTest(x) end_if;
       integral := hold(int)(f, x, context(args(3..args(0))));
       traperror((integral :=intlib::defInt(f, x, options)));
       if not hastype(integral, "int") and not hastype(integral, "limit") then
         integral := intlib::Simplify(integral);
       end_if;
       integral := subs(integral, hold(intlib::frozenInt)=hold(int), Unsimplified);
       // does the result contain an integral w.r.t. x?
       unevaluated_int := FALSE;
       if domtype(integral)<>piecewise then
         misc::maprec(integral,
           {"int"} = (i -> (if op(i, [2, 1])=op(x, 1) then unevaluated_int := TRUE; end; i)));
       end_if;
       if unevaluated_int and not options[hold(AlwaysExtractIntegrableParts)]=TRUE and
         intlib::Simplify::defaultValuation(integral) >
         3*intlib::Simplify::defaultValuation([f, x]) + 200 then
           return(hold(int)(f, x, intlib::printOptions(options)));
       end_if;
       return(integral);
     else
       error("Second argument must be either of form x or x=a..b")
     end_if;
  end_if
end_proc,
proc(a)
  local eq, integralSign, PVintegralSign;
begin
  if PRETTYPRINT = TRUE then
    integralSign := "  /",
                    " | ",
                    " | ",
                    "/  ":
    PVintegralSign := "  /",
                      "_|_",
                      " | ",
                      "/  ":
    if contains({op(a, 3..nops(a))}, PrincipalValue) then
      integralSign := PVintegralSign;
    end_if;
    if type(op(a, 2)) = "_equal" then
      // definite integral
      eq := op(a, [2,2]);
      if testtype(eq, "_range") then
        _outputSequencePower(stdlib::Exposed(stdlib::align(expr2text(op(eq, 2)),
                                                  integralSign,
                                                  expr2text(op(eq, 1)))),
                    _outputSequenceINFINITE(stdlib::Exposed(" "), op(a, 1),
                    stdlib::Exposed(" d"), op(a, [2,1])));
       else
        _outputSequencePower(stdlib::Exposed(
                                  stdlib::align(expr2text(eq), integralSign)),
                    _outputSequenceINFINITE(stdlib::Exposed(" "), op(a, 1),
                    stdlib::Exposed(" d"), op(a, [2,1])));
       end_if
     else
      // indefinite integral
      _outputSequencePower(stdlib::Exposed(stdlib::align(integralSign)),
                      _outputSequenceINFINITE(stdlib::Exposed(" "), op(a, 1),
                      stdlib::Exposed(" d"), op(a, 2)));
     end_if;
  else
    FAIL
  end:
end_proc):
int::type := "int":

int::info := "definite and indefinite integration [try ?int for details]":

int::type:= "int":
int::print:= "int":

// diff-attribute of int

int::diff :=
    proc(f)
	local i, a, u, t, x,chainmult,evaluate;
    begin
	if args(0) = 1 then return(f) end_if;

	a:= []; // variables that appear in the integration variable or the bounds
	u:= []; // other variables
	for i from 2 to args(0) do
	    if has(op(f,2), args(i)) then
		a:= append(a, args(i))
	    else
		u:= append(u, args(i))
	    end_if
	end_for;

	// exchange diff and int
	if nops(u) <> 0 then
	    return(diff(int(diff(op(f,1), op(u)), op(f,2)), op(a)))
	end_if;

	i:= contains(a, op(f,2));
	if i = 0 then
	    // diff(int(g,t=a..b),y)
	    if contains(a, (t:=op(f,[2,1]))) = 0 then
		// diff(int(g,t=a(x)..b(x)),x)
		// hold(diff)(args())
                x:=a[1]; delete a[1];
                // chainmult is necessary to prevent {+/-}infinity*0
                chainmult:=(f,d)->if d=0 then 0 else d*f end_if;
                // evaluate takes care of limitation process e.g. sin(t)/t,t=0
                evaluate:=
                  proc(g,x,dir)
                    local s;
                  begin
                    s:=NIL;
                    traperror((s:=subs(g,x)));
                    if s=NIL then
                      s:=intlib::limit(g,x,dir);
                    else
                      s
                    end_if;
                  end_proc;
                diff(chainmult(evaluate(op(f,1),t=op(f,[2,2,2]),Left),
                               diff(op(f,[2,2,2]),x))
                     -chainmult(evaluate(op(f,1),t=op(f,[2,2,1]),Right),
                                diff(op(f,[2,2,1]),x))
                     +int(diff(op(f,1),x),op(f,2)),
                     op(a))
	    else // diff(int(g,x=a..b),x)
		0
	    end_if
	else // diff(int(g,x),x)
	    delete a[i];
	    diff(op(f,1), op(a))
	end_if
    end_proc:

// float-attribute of int (numerical integration)

// old float attribute
//int:= slot(int, "float", proc(f, x) local r; begin
//   r := intlib::numint(f,x);
//   if r = FAIL then hold(int)(f, x) else r end_if
//end_proc):
// changed to new float attribute (W. Oevel, 31.8.99)

int::float := numeric::int:

int::expand :=
proc(a)
  local moreargs: DOM_LIST, s, integrand;
begin
  integrand:= op(a, 1);
  moreargs := [op(a, 2..nops(a))];
  integrand := expand(integrand, args(2..args(0)));
  case type(integrand)
    of "_plus" do
      return(_plus(eval(hold(int)(s, op(moreargs))) $ s in integrand));
    of "sum" do
      return(subsop(integrand,
		    1 = eval(hold(int)(op(integrand, 1), op(moreargs)))));
    of "_mult" do
      s := split([op(integrand)],
		 has,
		 if type(op(moreargs, 1)) = "_equal" then
		   lhs(op(moreargs, 1))
		 else
		   op(moreargs, 1)
		 end_if);
     return(_mult(op(s[2]), eval(hold(int)(_mult(op(s[1])), op(moreargs)))));
  end_case;
  eval(hold(int)(integrand, op(moreargs)))
end_proc:


// This should always be consistent with numeric::int::freeIndets in the definite case!
int::freeIndets:=
proc(J: "int")
begin
  if type(op(J, 2)) = "_equal" then
    (freeIndets(op(J, 1), args(2..args(0))) union freeIndets(op(J, [2, 2])), args(2..args(0))) minus
    freeIndets(op(J, [2, 1]), args(2..args(0)))
  else
    freeIndets(op(J, 1), args(2..args(0))) union freeIndets(op(J, 2), args(2..args(0)))
  end_if
end_proc:

// This should always be consistent with numeric::int::evalAt in the definite case!
int::evalAt:=
proc(J: "int", subst: Type::SetOf("_equal"))
  local hasx, notx, dummy;
begin
  subst := select(subst, eq -> has(J, op(eq, 1)));
  if type(op(J, 2)) = "_equal" or 
    type(op(J, 2)) = "_in" then
    // in int(f(x), x=0..x) (which is legal in mupad!), we want to carry
    // out a substitution x=... only on the last x
    notx:= select(subst, s -> op(s, 1) <> op(J, [2, 1]));
    // if one of the substituted values contains our bound variable,
    // rename the bound variable first, to avoid aliasing problems.
    if has(notx, op(J, [2, 1])) then
      notx := notx union {op(J, [2, 1]) = solvelib::getIdent(Any, indets([args()]))};
    end_if;
    int(evalAt(op(J, 1), notx),
      subsop(op(J, 2),
        1 = evalAt(op(J, [2, 1]), notx),
        2 = evalAt(op(J, [2, 2]), subst)),
      op(J, 3..nops(J)))
  else
    // indefinite integral
    [hasx, notx, dummy] := split(subst, has, op(J, 2));
    // allow renaming of integration variable, as in int(f(x), x) | x=y
    if nops(hasx) = 1 and op(hasx, [1, 1]) = op(J, 2) and
      nops(indets(op(hasx, [1, 2]))) = 1 and not has(J, indets(op(hasx, [1, 2]))) then
      if traperror((J := intlib::changevar(J, op(hasx), Unique))) = 0 then
        hasx := {};
      end_if;
    end_if;
    if hasx = {} then
      eval(hold(int)(evalAt(op(J,1), notx), op(J, 2..nops(J))));
    elif notx = {} then
      hold(evalAt)(args());
    else
      hold(evalAt)(eval(hold(int)(evalAt(op(J,1), notx), op(J, 2..nops(J)))), hasx);
    end_if
  end_if
end_proc:

int::operandsToSimplify:= [1]:


int::Re:=
proc(f)
begin
  f:= Re(f);
  if type(f) = "Re" then
    hold(int)(f, args(2..args(0)))
  else
    eval(hold(int)(f, args(2..args(0))))
  end_if
end_proc:

int::Im:=
proc(f)
begin
  f:= Im(f);
  if type(f) = "Im" then
    hold(int)(f, args(2..args(0)))
  else
    eval(hold(int)(f, args(2..args(0))))
  end_if
end_proc:


int::"transform::laplace":= loadproc(int::"transform::laplace",
                                     pathname("TRANS","LAPLACE"), "L_int"):

int::addpattern :=
loadproc(int::addpattern, pathname("INTLIB"), "addpattern"):

int::Content      := proc(Out, data)
                       local intFunc, opts;
                     begin
                       if nops(data) < 2 or
                          nops(data) > 2 and
                          contains({op(data, 3..nops(data))}, PrincipalValue) and
                          (type(op(data, 2)) <> "_equal" or type(op(data, [2, 2])) <> "_range") then
                         return(Out::stdFunc(data));
                       end_if;
                       if contains({op(data, 3..nops(data))}, PrincipalValue) then
                         intFunc := Out::CintPV;
                       else
                         intFunc := Out::Cint;
                       end_if;
                       opts := [op(data, 3..nops(data))];
                       if type(op(data, 2)) = "_equal" then
                         if type(op(data, [2, 2])) = "_range" then
                           // definite integral
                           Out::Capply(intFunc,
                                       opts,
                                       Out::Cbvar(Out(op(data, [2,1]))),
                                       Out::Clowlimit(Out(op(data, [2,2,1]))),
                                       Out::Cuplimit( Out(op(data, [2,2,2]))),
                                       Out(op(data,1)));
                         else
                           // domain of integration
                           Out::Capply(Out::Cint,
                                       opts,
                                       Out::Cbvar(Out(op(data, [2,1]))),
                                       Out::Ccondition(Out(hold(_in)(op(data, [2, 1]), op(data, [2, 2])))),
                                       Out(op(data,1)));
                         end_if
                       else
                         // indefinite integral
                         Out::Capply(Out::Cint,
                                     opts,
                                     Out::Cbvar(Out(op(data, 2))),
                                     Out(op(data,1)));
                       end_if;
                     end_proc:

int::simplify := loadproc(int::simplify,pathname("STDLIB","SIMPLIFY"), "int"):
int::interface := {hold(addpattern)}:

