/*++

inverse -- inverse of a matrix

Calls: inverse(A)
   
Parameters:
  A - a 2-dim array, an hfarray, or a matrix of category Cat::Matrix

Overloadable
   
++*/

inverse := proc(A)
begin
   if args(0) <> 1 then
      error("expecting one argument");
   end_if:
   if A::dom::inverse <> FAIL then
      return(A::dom::inverse(A));
   end_if:
   case domtype(A) 
   of DOM_ARRAY do
         if op(A, [0, 1]) <> 2 then
            error("expecting a matrix as a 2 dimensional array");
         end_if:
         if op(A, [0, 2, 2]) - op(A, [0, 2, 1]) <>
            op(A, [0, 3, 2]) - op(A, [0, 3, 1]) then
            error("expecting a square matrix");
         end_if:
         return(numeric::inverse(A, Symbolic)); 
   of DOM_HFARRAY do
         if op(A, [0, 1]) <> 2 then
            error("expecting a matrix as a 2 dimensional hfarray");
         end_if:
         if op(A, [0, 2, 2]) - op(A, [0, 2, 1]) <>
            op(A, [0, 3, 2]) - op(A, [0, 3, 1]) then
            error("expecting a square matrix");
         end_if:
         return(hfa::inverse(A));
   end_case;
   if A::dom::hasProp(Cat::Matrix)=TRUE then
      return(A^(-1));
   end_if:
   hold(inverse)(A);
end_proc:
inverse := funcenv(inverse):
inverse::Content := stdlib::genOutFunc("CinverseMatrix", 1):
