//      

//   loadproc-analyze
//     patched version to keep statistic information for analysis
//   2002/2003, bij
//
//   objects, that contains information
//
//   all objects, that are defined as loadproc object
//       stdlib::LoadProc::loadTable : DOM_TABLE
//   all files, that are read - evaluated loadproc objects
//       stdlib::LoadProc::fileTable : DOM_TABLE
//   all objects defined as loadproc and read from a file
//       stdlib::LoadProc::readTable : DOM_TABLE
//   counter of defined loadproc objects
//       stdlib::LoadProc::loadCounter : DOM_INT
//   counter of read loadproc objects
//       stdlib::LoadProc::readCounter : DOM_INT
//   counter of read files
//       stdlib::LoadProc::fileCounter : DOM_INT
//   name of current read file
//       stdlib::LoadProc::file : DOM_STRING
//   current read level (nested reads)
//       stdlib::LoadProc::depth: DOM_INT
//   
//   !!! *** All other parts are identical to the original loadproc *** !!!
//           Differences are completely enclosed by %if statements
//   
//   This patched version slowes -only- loading of MuPAD objects ca. 5 % down.
//   No other effects.
//   

// LoadProc -- domain to load library functions on demand 

stdlib::LoadProc:= newDomain("stdlib::LoadProc"):
stdlib::LoadProc::create_dom:=hold(stdlib::LoadProc):
stdlib::LoadProc::evaluateIndex:=TRUE:

// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
  // first LIBPATH when reading sysinit
  stdlib::LIBPATH := LIBPATH:
  // all objects as loadproc
  stdlib::LoadProc::loadTable:= table():
  // all files be read
  // this table is initialized with all files, that are read inside 'sysinit.mu'
  stdlib::LoadProc::fileTable:= 
    table("sysinit"               = [-8],
          "STDLIB/read"           = [-7],
          "STDLIB/alias"          = [-6],
          "STDLIB/unalias"        = [-5],
          "STDLIB/pathname"       = [-4],
          "STDLIB/loadproc"       = [-3],
          "LIBFILES/stdlib"       = [-2],
          "LIBFILES/specfunc"     = [-1],
          "LIBFILES/dom_interval" = [ 0]):

  // all objects defined as loadproc and read from a file
  stdlib::LoadProc::readTable:= table():
  // defined loadproc objects
  stdlib::LoadProc::loadCounter:= 0:
  // read loadproc objects
  stdlib::LoadProc::readCounter:= 0:
  // read files
  stdlib::LoadProc::fileCounter:= 0:
  // current read file
  stdlib::LoadProc::file:= "":
  // current read level (nested reads)
  stdlib::LoadProc::depth:= -1:
//     end_if; // %end
// %end% different from loadproc.mu

loadproc := proc(p)
    option noDebug, hold;
begin
    if testargs() then
	if args(0) < 3 then
	    error("wrong no of arguments")
	end_if;

	case domtype(p)
	of DOM_IDENT do
	of DOM_VAR do
	of DOM_EXPR do
	    break;
	otherwise
	    error("wrong procedure name")
	end_case;
    end_if;

// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
      if contains(stdlib::LoadProc::loadTable, args(1)) then
        sysassign(stdlib::LoadProc::loadTable[args(1)], (stdlib::LoadProc::loadTable[args(1)] .
                                                         [context(args(2..3)),
                                                          stdlib::LoadProc::loadCounter + 1,
                                                          stdlib::LoadProc::file]))
      else
        sysassign(stdlib::LoadProc::loadTable[args(1)], [context(args(2..3)),
                                                         stdlib::LoadProc::loadCounter + 1,
                                                         stdlib::LoadProc::file])
      end_if;
      sysassign(stdlib::LoadProc::loadCounter, stdlib::LoadProc::loadCounter + 1);
//     end_if; // %end
// %end% different from loadproc.mu

    new(stdlib::LoadProc, p, op(context([args(2..args(0))])))
end_proc:

stdlib::LoadProc::isValid :=
proc(lpn)
  option noDebug;
  name loadproc;
  local op1, op0, err;
begin
  err := FALSE;
  op1 := op(lpn,1);
  if domtype(op1) = DOM_IDENT then
    if eval(subsop(hold(val)(1), 1=op(lpn,1))) = lpn then
      err := TRUE;
    end_if;
  elif type(op1) = "slot" then
    op0 := op(op1, 1);
    if domtype(op0) = DOM_IDENT then
      op0 := eval(op0);
    end_if;
    if domtype(op0) = DOM_DOMAIN and
      eval(subsop(hold(indexval)(op0, 1), 2=op(op1,2))) = lpn then
      err := TRUE;      
    elif domtype(op0) = DOM_FUNC_ENV and domtype(op(op0, 3)) = DOM_TABLE and
      eval(subsop(hold(indexval)(op(op0, 3), 1), 2=op(op1,2))) = lpn then
      err := TRUE;      
    end_if;
  end_if;
  if err = TRUE then
      error("'".expr2text(op(lpn,1))."' not defined in file '".op(lpn,2).op(lpn,3).".mu'");
  end_if;
end_proc:

stdlib::LoadProc::new := proc()
    option noDebug;
    name loadproc;
begin
    new(stdlib::LoadProc, args())
end_proc:

stdlib::LoadProc::read_file:= proc(path, fnam)
    option escape, noDebug;
    name loadproc;
    local p, f, pref_val, lev, read_file;
    save PRETTYPRINT;
begin
    pref_val:= 0;
    // be shure not to load Pref::verboseRead if not used yet
    if domtype(val(Pref)) = DOM_DOMAIN and domtype(Pref::_verboseRead) = DOM_INT then
      pref_val := Pref::_verboseRead;
      if pref_val <> 0 then
        PRETTYPRINT:= FALSE
      end_if
    end_if;

// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
       sysassign(stdlib::LoadProc::depth, stdlib::LoadProc::depth + 1);
       lev := _concat("  " $ stdlib::LoadProc::depth);
//     else // %else
//       lev := "";
//     end_if; // %end
// %end% different from loadproc.mu

    for p in LIBPATH do
	// read file, try mb-file first, then mu-file 
	f:= fopen(p.path.fnam.".mb");
	if f <> FAIL then
// %if% different from loadproc.mu
//          %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
             sysassign(stdlib::LoadProc::file, p.path.fnam.".mb");
             read_file := p.path.fnam.".mb";
//           end_if; // %end
// %end% different from loadproc.mu
            case pref_val
	    of 0 do
                break
            of 1 do
            	if strmatch(path,"LIBFILES") then
                    print(Unquoted,lev."loading package '".fnam."' from ".p);
            	end_if;
		break
            of 2 do 
		if strmatch(path,"LIBFILES") then
                    print(Unquoted,lev."loading package '".fnam."' [".p."]");
		else
                    print(Unquoted,lev."reading file ".p.path.fnam.".mb");
		end_if
            end_case;

            stdlib::syseval(fread(f, Plain, Quiet));
	    fclose(f);
	    break;
	end_if;

	f:= fopen(p.path.fnam.".mu");
	if f = FAIL then next end_if;
// %if% different from loadproc.mu
//        %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
           sysassign(stdlib::LoadProc::file, p.path.fnam.".mu");
           read_file := p.path.fnam.".mu";
//        end_if; // %end
// %end% different from loadproc.mu
	case pref_val
	of 0 do 
	    break
	of 1 do
	    if strmatch(path,"LIBFILES") then
                print(Unquoted,lev."loading package '".fnam."' [".p."]");
            end_if;
	    break
	of 2 do
	    if strmatch(path,"LIBFILES") then
                print(Unquoted,lev."loading package '".fnam."' [".p."]");
	    else
	        print(Unquoted,lev."reading file ".p.path.fnam.".mu");
	    end_if
	end_case;
    
        stdlib::syseval(fread(f, Plain, Quiet));
	fclose(f);
	break
    end_for;

    if f = FAIL then
        error("can't read file '".path.fnam.".mu'")
    end_if;
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
       if f <> FAIL then
         sysassign(stdlib::LoadProc::fileCounter, stdlib::LoadProc::fileCounter + 1);
         if contains(stdlib::LoadProc::fileTable, path.fnam) then
           sysassign(stdlib::LoadProc::fileTable[path.fnam],
                     stdlib::LoadProc::fileTable[path.fnam].[stdlib::LoadProc::fileCounter,
                                                             read_file])
         else
           sysassign(stdlib::LoadProc::fileTable[path.fnam], [stdlib::LoadProc::fileCounter,
                                                              read_file])
         end_if
       end_if;
       sysassign(stdlib::LoadProc::depth, stdlib::LoadProc::depth - 1);
//     end_if; // %end
// %end% different from loadproc.mu
    null()
end_proc:

stdlib::LoadProc::testtype := proc(elem, ttype) : DOM_BOOL 
    option noDebug;
    name loadproc::testtype;
begin
    bool(type(elem) = ttype /* stdlib::LoadProc */ )
end_proc:

stdlib::LoadProc::evaluate := proc(lpn)
    option noDebug;
    name loadproc;
begin
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
      // prevent reading
      if stdlib::LoadProc::dontRead = TRUE then return(lpn) end_if;
//     end_if; // %end
// %end% different from loadproc.mu
    stdlib::LoadProc::read_file(op(lpn,2), op(lpn,3));
    dom::isValid(lpn);
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
      stdlib::LoadProc::read(op(lpn, 1));
//     end_if; // %end
// %end% different from loadproc.mu
    if nops(lpn) > 3 then
    // call float attribute 
	op(lpn,4)(op(lpn, 5..nops(lpn)))
    end_if;
    context(op(lpn,1))
end_proc:

stdlib::LoadProc::func_call := proc(lpn)
    option noDebug;
    name loadproc;
begin
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
    // prevent reading
    if stdlib::LoadProc::dontRead = TRUE then return(lpn(args(2..args(0)))) end_if;
//     end_if; // %end
// %end% different from loadproc.mu
    stdlib::LoadProc::read_file(op(lpn,2), op(lpn,3));
    dom::isValid(lpn);
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
      stdlib::LoadProc::read(op(lpn, 1));
//     end_if; // %end
// %end% different from loadproc.mu
    if nops(lpn) > 3 then
    // call float attribute 
	op(lpn,4)(op(lpn, 5..nops(lpn)))
    end_if;
    context(op(lpn,1)(args(2..args(0))))
end_proc:

stdlib::LoadProc::set_func_call := proc(lpn)
    option noDebug;
    name loadproc;
    local a,v;
begin
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
    // prevent reading
    if stdlib::LoadProc::dontRead = TRUE then return(lpn) end_if;
//     end_if; // %end
// %end% different from loadproc.mu
    stdlib::LoadProc::read_file(op(lpn,2), op(lpn,3));
    dom::isValid(lpn);
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
      stdlib::LoadProc::read(op(lpn, 1));
//     end_if; // %end
// %end% different from loadproc.mu
    if nops(lpn) > 3 then
    // call float attribute 
	op(lpn,4)(op(lpn, 5..nops(lpn)))
    end_if;
    context(op(lpn,1))
end_proc:

stdlib::LoadProc::posteval := proc(lpn)
    option noDebug;
    name loadproc;
  begin
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
    // prevent reading
    if stdlib::LoadProc::dontRead = TRUE then return(lpn) end_if;
//     end_if; // %end
// %end% different from loadproc.mu
    stdlib::LoadProc::read_file(op(lpn,2), op(lpn,3));
    dom::isValid(lpn);
// %if% different from loadproc.mu
//    %if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
      stdlib::LoadProc::read(op(lpn, 1));
//     end_if; // %end
// %end% different from loadproc.mu
    if nops(lpn) > 3 then
    // call float attribute 
	op(lpn,4)(op(lpn, 5..nops(lpn)))
    end_if;
    context(op(lpn,1))
end_proc:

// %if% different from loadproc.mu
//%if strmatch(_pref(hold(UserOptions)), "ANALYZE") then
stdlib::LoadProc::read:=
  proc(obj)
    option noDebug;
    name loadproc;
  begin
    if not contains(stdlib::LoadProc::loadTable, obj) then
      error("object to read is not in loadTable")
    else
      sysassign(stdlib::LoadProc::loadTable[obj],
                append(stdlib::LoadProc::loadTable[obj], "loaded"));
      sysassign(stdlib::LoadProc::readTable[obj],
                append(subsop(stdlib::LoadProc::loadTable[obj],
                              3 = stdlib::LoadProc::readCounter),
                       stdlib::LoadProc::depth + 1));
      sysassign(stdlib::LoadProc::readCounter, stdlib::LoadProc::readCounter + 1);
    end_if
  end_proc:
//end_if: // %end
// %end% different from loadproc.mu

null():

// end of file 
