//    

// kg, 21/04/98 

/*++
operator -- define operator

operator(name, expr [, type [, prio ] ] <, Global>)
operator(name, Delete <, Global>)

name - operator name (string)
expr - expression representing the operator
type - type of operator (Prefix, Postfix, Binary, Nary)
default: Nary
prio - operator priority (400-2099)
default: 1800
Global - define for interactive parser instead of current
++*/

operator:=
proc(nam, hfc, typ, prio)
  local a, n, i, pc, global, fc, out;
  save hfc_id;
  option hold;
  option noDebug;
begin
  a := [args()];
  n := contains(a, Global);
  if n = 0 then
    global := null();
  else
    global := Global;
    delete a[n];
  end_if;
  n := nops(a);
  if nops(a) > 1 then
    [nam, fc] := context([nam, hfc]);
    if nops(a) > 2 then
      typ := context(typ);
      if nops(a) > 3 then
        prio := context(prio);
      end_if;
    end_if;
  end_if;
  if testargs() then
    if n <> 2 and n <> 4 then
      error("wrong no of args")
    end_if;
    if domtype(nam) <> DOM_STRING or length(nam) > 32 then
      error("illegal operator name")
    end_if;
    if n = 4 then
      if typ <> hold(Prefix) and typ <> hold(Postfix) and
        typ <> hold(Binary) and typ <> hold(Nary) then
        error("illegal operator type")
      end_if;
      if domtype(prio) <> DOM_INT or prio < 1 or prio >= 2000 then
        error("illegal operator priority")
      end_if;
    end_if;
  end_if;

  pc:= _parser_config(global);
  if pc = null() then
    pc:= [table(), table(), table(), []]
  end_if;

  if n = 2 then
    if fc = hold(Delete) then
      i:= contains(map(pc[4], op, 1), nam);
      if i = 0 then
        return(null());
      end_if;
      delete pc[4][i];
      _parser_config(global, pc);
      return(null());
    end_if;
    typ:= hold(Nary);
    prio:= 1300;
  end_if;

  i:= contains(map(pc[4], op, 1), nam);
  if i <> 0 then
    error("operator already exists")
  end_if;

  // set output method
  hfc_id := hfc;
  if domtype(fc) <> DOM_FUNC_ENV and domtype(hfc) = DOM_IDENT then
    evalassign(hfc_id, funcenv(fc));
  end_if;
  case typ
    of Nary do
      out := builtin(1100, prio,
                     stringlib::collapseWhitespace(" ".nam." "),
                     expr2text(hfc));
      break;

    of Binary do
      out := builtin(1097, prio,
                     stringlib::collapseWhitespace(" ".nam." "),
                     expr2text(hfc));
      break;
      
    of Prefix do
      out := builtin(1098, prio,
                     if stringlib::validIdent(nam[-1]) then
                       stringlib::collapseWhitespace(nam." ")
                     else
                       nam
                     end,
                     expr2text(hfc));
      break;
      
    of Postfix do
      out := builtin(1099, prio,
                     if stringlib::validIdent(nam[1]) then
                       stringlib::collapseWhitespace(" ".nam)
                     else
                       nam
                     end,
                     expr2text(hfc));
      break;
  end_case;
  if domtype(hfc) = DOM_IDENT and protected(hfc_id) = None then
    evalassign(hfc_id, subsop(context(hfc), 2=out));
  end_if;
  pc[4]:= append(pc[4], [nam,fc,typ,prio]);
  _parser_config(global, pc);
  null()
end_proc:

// end of file 
