//      
/*++

random - random number generator
   
random()   
random(range)   
random(integer)   
   
range   - an integer range
integer - a nonnegative integer
   
random()     returns a 12 digit nonnegative random integer.
random(a..b) returns a procedure  which, when called, generates 
             random integers in the range a..b.
random(n)    is the abbreviated form of rand(0..n-1).
   
The global variable SEED can be used to alter the sequence of random 
numbers  generated, by setting it to any non-zero integer.

++*/

random :=
proc(r)
  option escape;
  local x, _OFFSET, _DIVISOR, _CONCATS, _MODULUS, _MULTIPLIER, _SHIFT;
begin

  if not testtype(SEED, DOM_INT) or iszero(SEED) then
    SEED := 424242;
  end_if;

    _MODULUS := 999999999989;
    _MULTIPLIER := 427419669081;
    if args(0) = 0 then 
      SEED := modp((_MULTIPLIER * SEED),_MODULUS);
    else

      if type(r) = "_range" then
         _OFFSET := op(r, 1);
         _DIVISOR := op(r, 2);
         if not (domtype(_OFFSET)=DOM_INT and domtype(_DIVISOR)=DOM_INT) or
	     (_DIVISOR < _OFFSET) then
            error("invalid range")
         end_if;
         _DIVISOR := _DIVISOR-_OFFSET+1
      elif domtype(r)=DOM_INT and (0 < r) then 
	 _OFFSET := 0; _DIVISOR := r
      else 
	 error("invalid arguments")
      end_if;
      x := _MODULUS; _CONCATS := 1;
      while x < _DIVISOR do  
	     x := _MODULUS*x; _CONCATS := _CONCATS+1 
      end_while;
      _CONCATS := _CONCATS-1;
      _SHIFT := 1000000000000;

      if _CONCATS = 0 then

        proc()
          name random;
        begin
          SEED := modp((_MULTIPLIER * SEED), _MODULUS);
          modp(SEED, _DIVISOR) + _OFFSET
        end_proc

      elif _CONCATS = 1 then

        proc()
          name random;
          local t;
        begin
          t:= SEED := modp(_MULTIPLIER * SEED, _MODULUS);
          SEED := modp(_MULTIPLIER * SEED, _MODULUS);
          t := _SHIFT * t + SEED;
          modp(t, _DIVISOR) + _OFFSET
        end_proc


      else

        proc()
          name random;
          local i, t;
        begin
          t:= SEED := modp(_MULTIPLIER * SEED, _MODULUS);
          for i from 1 to _CONCATS do
            SEED := modp(_MULTIPLIER * SEED, _MODULUS);
            t := _SHIFT * t + SEED
          end_for;
          modp(t, _DIVISOR) + _OFFSET
        end_proc
      end_if
    end_if
end_proc:

