
stdlib::set_plus:=
proc() 
  local argv, types, i, sets, expressions, other, newidents: DOM_LIST;
begin
  if args(0) = 1 then
    return(args(1))
  end_if;  
  argv:= [args()];
  types:= map(argv, type);
  if (i:= contains(types, DOM_SET)) > 0 then   
    return(DOM_SET::_plus(argv[i], op(argv, 1..i-1), op(argv, i+1..nops(argv))))
  elif (i:= contains(types, DOM_LIST)) > 0 then 
    return(DOM_LIST::_plus(argv[i], op(argv, 1..i-1), op(argv, i+1..nops(argv))))
  end_if;  
  [expressions, other, i]:= split(argv, testtype, Type::Arithmetical);
  [sets, other, i]:= split(other, testtype, Type::Set);
  assert(nops(sets) > 0);
  if nops(other) > 0 then
    error("Illegal argument ".expr2text(other[1]))
  end_if;  
  newidents:= solvelib::getMultipleIdent(C_, nops(sets), indets([sets, other]));
  Dom::ImageSet(_plus(op(newidents), op(expressions)), newidents, sets)
end_proc:


stdlib::set_mult:=
proc()
  local argv, types, i, sets, expressions, other, newidents: DOM_LIST;
begin
  if args(0) = 1 then
    return(args(1))
  end_if;  
  argv:= [args()];
  types:= map(argv, type);
  if (i:= contains(types, DOM_SET)) > 0 then   
    return(DOM_SET::_mult(argv[i], op(argv, 1..i-1), op(argv, i+1..nops(argv))))
  elif (i:= contains(types, DOM_LIST)) > 0 then 
    return(DOM_LIST::_mult(argv[i], op(argv, 1..i-1), op(argv, i+1..nops(argv))))
  end_if;  
  [expressions, other, i]:= split(argv, testtype, Type::Arithmetical);
  [sets, other, i]:= split(other, testtype, Type::Set);
  assert(nops(sets) > 0);
  if nops(other) > 0 then
    error("Illegal argument ".expr2text(other[1]))
  end_if;  
  newidents:= solvelib::getMultipleIdent(C_, nops(sets), indets([sets, other]));
  Dom::ImageSet(_mult(op(newidents), op(expressions)), newidents, sets)
end_proc:


stdlib::set_power:=
proc(b, e)
  local z;
begin
  if type(b) = DOM_SET or type(e) = DOM_SET then 
    DOM_SET::_power(b, e)
  elif type(b) = DOM_LIST or type(e) = DOM_LIST then
    DOM_LIST::_power(b, e)
  elif testtype(b, Type::Arithmetical) then
    assert(testtype(e, Type::Set));
    z:= solvelib::getIdent(e, indets([b, e]));
    Dom::ImageSet(b^z, z, e)
  elif testtype(b, Type::Set) then
    if testtype(e, Type::Arithmetical) then
      z:= solvelib::getIdent(b, indets([b, e]));
      Dom::ImageSet(z^e, z, b)
    elif testtype(e, Type::Set) then
      z:= solvelib::getMultipleIdent(C_, 2, indets([b, e]));
      Dom::ImageSet(z[1]^z[2], z, [b, e])
    else
      error("Illegal argument ".expr2text(e))
    end_if
  else
    error("Illegal argument ".expr2text(b))
  end_if
end_proc:

// end of file
