// 

// various slots for DOM_SET

DOM_SET::sort:= proc(s : DOM_SET, f = FAIL) : DOM_LIST 
  option noDebug;
begin
  if f = FAIL then
    sort([op(s)]);
  else
    sort([op(s)], f);
  end_if;
end_proc:

DOM_SET::_index := 
proc(s : DOM_SET, i)
  local list;
  option noDebug;
begin 
  if args(0) <> 2 then return(FAIL); end_if;
  if i = 0 then DOM_SET 
  else
    list := DOM_SET::sort(s);
    if type(i) = "_range" then
      if abs(op(i, 1)) > nops(list) or
        abs(op(i, 2)) > nops(list) then
        {}
      else
        {op(list[i])}
      end_if
    elif type(i) = DOM_INT then
      if abs(i) > nops(list) then
        FAIL
      else
        list[i]
      end_if
    else
      FAIL;
    end_if
  end_if
end_proc:

DOM_SET::_plus:=
proc(S, a)
  local j, inh;
begin
  if args(0) = 1 then
     return(map(S, _plus))
  end_if;
  if domtype(S) = DOM_LIST then 
    assert(type(a) = DOM_SET);
    return(map(a, x -> S + x)) 
  end_if;  
  if S = {} then
    return({})
  end_if;
  case domtype(a)
    of DOM_INT do
    of DOM_RAT do
    of DOM_COMPLEX do
    of DOM_FLOAT do       
    of DOM_IDENT do
    of DOM_POLY do
    of DOM_LIST do  
      return(map(S, _plus, a))
    of DOM_EXPR do
      if testtype(a, Type::Union(Type::Relation, Type::Arithmetical)) then
        return(select(map(S, _plus, a), _unequal, undefined))
      elif type(a) = "_union" then
        return(map(a, _plus, S))
      elif type(a) = "_intersect" then  
        return(_union(_intersect::_plus(a, j) $j in S))
      elif type(a) = "_minus" then
        return(_union(op(map(S, _plus, a))))
      else
        return(hold(_plus)(S, a))
      end_if
    of DOM_SET do
      if nops(S)*nops(a) > 100 and nops(S) >=3 and nops(a) >= 3 then
         return(Dom::ImageSet(#X+#Y, [#X, #Y], [S, a]))
      end_if;
      return(select(_union(map(S, _plus, j) $ j in a), _unequal, undefined))
    of DOM_INTERVAL do
      return(_union(_plus(j,a)$j in S))
    of DOM_VAR do
      return(hold(_plus)(S, a));
  end_case;
  if a::dom::hasProp(Cat::Set)=TRUE then
    inh := a::dom::inhomog_plus[DOM_SET];
    if type(inh)<>"_index" then       
      return(inh(a, S))
    end_if
  end_if;         
  error("Illegal argument ".expr2text(a))
end_proc:

DOM_SET::_mult:=
proc(S, a)
  local j, inh;
begin
  if args(0) = 1 then
     return(map(S, _mult))
  end_if;

  if domtype(S) = DOM_LIST then 
    assert(type(a) = DOM_SET);
    return(map(a, x -> S * x)) 
  end_if;  
  
  if S={} then
    return({})
  end_if;
  
  case domtype(a)
    of DOM_INT do
    of DOM_RAT do
    of DOM_COMPLEX do
    of DOM_FLOAT do
    of DOM_IDENT do
    of DOM_POLY do
    of DOM_LIST do  
      return(map(S, _mult, a))
    of DOM_EXPR do
      if testtype(a, Type::Union(Type::Relation, Type::Arithmetical)) then
        return(select(map(S, _mult, a), _unequal, undefined))
      elif type(a) = "_union" then
        return(map(a, _mult, S))
      elif type(a) = "_intersect" then
        return(_union(_intersect::_mult(a, j) $j in S))
      elif type(a) = "_minus" then
        return(_union(op(map(S, _mult, a))))
      else
        return(hold(_mult)(S, a))
      end_if
    of DOM_SET do
      if nops(S)*nops(a) > 100 and nops(S) >=3 and nops(a) >= 3 then
         return(Dom::ImageSet(#X*#Y, [#X, #Y], [S, a]))
      end_if;
      return(select(_union(map(S, _mult, j) $ j in a), _unequal, undefined))
    of DOM_INTERVAL do
      return(_union(_mult(j,a)$j in S))
    of DOM_VAR do
      return(hold(_mult)(S, a))
  end_case;
  if a::dom::hasProp(Cat::Set)=TRUE then
    inh := a::dom::inhomog_mult[DOM_SET];
    if type(inh)<>"_index" then       
       return(inh(a, S))
    end_if;
  end_if;
  error("Illegal argument ".expr2text(a))
end_proc:

DOM_SET::_power:= proc(b, e)
  local inh;
begin
  if domtype(b)= DOM_SET then
    if domtype(e)= DOM_SET then
      return(DOM_SET::bin_power(b, e))
    else
      inh := DOM_SET::inhomogleft_power[domtype(e)];
      if type(inh)="_index" then
        return(hold(_power)(b,e))
      else
        return(inh(b,e))
      end_if
    end_if
  end_if;
  // domtype(e)=DOM_SET
  inh := DOM_SET::inhomogright_power[domtype(b)];
  if type(inh)="_index" then
    return(hold(_power)(b,e))
  else
    return(inh(b,e))
  end_if
end_proc:

DOM_SET::bin_power:= proc(b:DOM_SET, e:DOM_SET)
 local a, i, j;
begin
  {(if traperror((a:=i^j))=0 then
     a
   else
     null()
   end_if)
     $i in b $j in e} 
end_proc:

DOM_SET::inhomogleft_power:= table():
DOM_SET::inhomogleft_power[DOM_INT]:=
DOM_SET::inhomogleft_power[DOM_RAT]:=  
DOM_SET::inhomogleft_power[DOM_FLOAT]:=
DOM_SET::inhomogleft_power[DOM_IDENT]:=
DOM_SET::inhomogleft_power[DOM_COMPLEX]:=
DOM_SET::inhomogleft_power[DOM_LIST]:=
DOM_SET::mapleft_power:=
  (S, e) -> map(S,
                proc(s)
                  local a;
                begin
                  if traperror((a:=s^e))=0 then
                    a
                  else
                    null()
                  end_if
                end_proc):
DOM_SET::inhomogleft_power[DOM_EXPR]:=
proc(S, e)
  local s;
begin
  if testtype(e, Type::Arithmetical) then
    DOM_SET::mapleft_power(S, e)
  elif testtype(e, Type::Set) then
    _union(Dom::ImageSet(s^#X, #X, e) $s in S)
  else
    hold(_power)(S, e)
  end_if   
end_proc:
                
                
DOM_SET::inhomogright_power:= table():  
DOM_SET::inhomogright_power[DOM_INT]:=
DOM_SET::inhomogright_power[DOM_RAT]:=  
DOM_SET::inhomogright_power[DOM_FLOAT]:=
DOM_SET::inhomogright_power[DOM_IDENT]:=
DOM_SET::inhomogright_power[DOM_COMPLEX]:=
DOM_SET::inhomogright_power[DOM_LIST]:=
DOM_SET::mapright_power:=
(b, S) -> map(S,
                proc(s)
                  local a;
                begin
                  if traperror((a:=b^s))=0 then
                    a
                  else
                    null()
                  end_if
                end_proc):
DOM_SET::inhomogright_power[DOM_EXPR]:=
proc(b, S)
  local s;
begin
  if testtype(b, Type::Arithmetical) then
    DOM_SET::mapright_power(b, S)
  elif testtype(b, Type::Set) then
    _union(Dom::ImageSet(#X^s, #X, b) $s in S)
  else
    hold(_power)(b, S)
  end_if   
end_proc:
                
                

DOM_SET::coerce:= proc(x)
    local T;
begin
    T:= x::dom;
    case T
    of DOM_LIST do
        return( {op(x)} )
    of DOM_ARRAY do
        return( {op(x)} )
    of DOM_STRING do
        return(expr2text(x))
    otherwise
        return(T::convert_to(x,DOM_SET))
    end_case
end_proc:
