//      

//*****************************************************
// 'sysevalassign'                                       
//                                                       
// Aufruf: sysevalassign(left, right, depth);            
//                                                       
// Prozedur realisiert eine Zuweisung, die vor der       
// Ausfuehrung der eigentlichen Zuweisung die linke      
// Seite 'depth' - Stufen evaluiert.                     
//                                                       
// Argumente : 'left'  --  linke Seite der Zuweisung     
//             'right' --  rechte Seite der Zuweisung    
//             'depth' --  Evaluierungsstufe             
//                                                       
//*****************************************************

sysevalassign:=
  proc()
    option hold;
    local depth;
  begin
    if testargs() then
      if args(0) < 2 or args(0) > 3 then
        error("Wrong number of arguments")
      end_if;
      if args(0) = 3 then
        depth := context(args(3));
        if domtype(depth) <> DOM_INT or depth < 0 then
          error("Illegal third argument");
        end_if;
      end_if
    end_if;
    
    if args(0) = 2 then
      depth := 0
    else
      depth := context(args(3));
    end_if;
    
    if depth = 0 then
      context(subsop(hold(sysassign(NIL, NIL)), 1 = context(args(1)), 2 = context(args(2))))
    else
      context(subsop(hold(sysassign(NIL, NIL)),
		     1 = context(hold(level)(args(1), depth)),
		     2 = context(args(2))
		    )
	     )
    end_if
  end_proc:
