_xor:= funcenv
(proc()
   name _xor;
   local argv : DOM_LIST,
         result, i, j;
 begin
   // FALSE is the neutral element
   argv:= select([args()], _unequal, FALSE);

   if contains(argv, UNKNOWN) > 0 then
     return(UNKNOWN)
   end_if;

   // flatten
   argv:= map(argv, x-> if type(x) = "_xor" then op(x) else x end_if);
 
   result := select(argv, _unequal, TRUE);

   case nops(result)
       of 0 do
       result := FALSE;
       break
     of 1 do
       if testtype(result[1], "_seqgen") or testtype(result[1], "_seqgen") then
         // keep result
         result:= procname(op(result, 1))
       else
         result:= op(result, 1);
       end_if;
       break
     otherwise
       if nops({op(result)}) <> nops(result) then
         // there are identical arguments;
         // we can remove them in pairs
         result := sort(result);
         i := 1;
         for j from 2 to nops(result) do
           if i = 0 or result[j] <> result[i] then
             i := i + 1;
             result[i] := result[j];
           else
             result[i] := FAIL;
             i := i - 1;
           end_if;
         end_for;
         result := [op(result, 1..i)];
       end_if;
       if nops(result) = 0 then
         result:= FALSE;
       elif nops(result) = 1 then
         result:= op(result)
       else
         result:= procname(op(result));
       end_if;
   end_case;
   
 
   if nops(select(argv, _equal, TRUE)) mod 2 = 0 then
     result
   else
     not result
   end_if;
 end_proc,
 builtin(1100, 150, " xor ", "_xor" )):
// do not touch the priority; has to be consistent with the
// MuPAD parser and output::Priority (Typesetting)

_xor::type  := "_xor":
_xor::print := "_xor":
_xor::bool  := proc()
               begin
                 _xor(map(args(), bool))
               end_proc:

_xor::float := () -> hold(_xor)(op(map([args()], float))):


_xor::TeX        :=
  (arg1, arg2, arg3) -> generate::TeXoperator(" xor ", arg3,
                                              output::Priority::Xor, op(arg2)):
_xor::Content := stdlib::genOutFunc("Cxor", 2, infinity):

