/*-

stringlib::format -- formats strings

Calling sequence:

stringlib::format(s, len, align, pat)

stringlib::format(s, len)          -> stringlib::format(s, len, Left, " ")
stringlib::format(s, len, pat)     -> stringlib::format(s, len, Left, pat)
stringlib::format(s, len, align)   -> stringlib::format(s, len, align, " ")

Parameter:

s     - string
pat   - character (length(pat) = 1)
len   - positive integer
align - Left, Right or Center


Examples:

>> stringlib::format("abc", 10);

                               "abc       "

>> stringlib::format("abc", 10, Center, "_");

                               "___abc____"

-*/

stringlib::format := proc(s:DOM_STRING, len, align = hold(Left), pat = " ")
   local l, d1, d2, OP;
begin
   if args(args(0)) = hold(Separat) then
     OP := 1
   else
     OP := 0
   end_if;
   case args(0) - OP
     of 1 do
       return(s)
     of 3 do
        if type(align) = DOM_STRING then
           pat := align; align := hold(Left)
        else
           pat := " "
        end_if;
        break
     of 2 do
        align := hold(Left);
        break
     of 4 do 
        break
     otherwise
        error("Wrong number of arguments")
   end_case;

   if testargs() then
      if not (type(len) = DOM_INT and len >= 0) then
         error("2nd argument must be a nonnegative integer")
      end_if;
      if not contains({hold(Left), hold(Right), hold(Center)}, align) then
         error("Illegal alignment")
      end_if;
      if type(pat) <> DOM_STRING or length(pat) <> 1 then
         error("Illegal pattern")
      end_if;

   end_if;
        
   l := length(s);
   if len < l then
      substring(s, 1, len)
   elif len = l then
      s
   else
      OP := op([_concat, id], OP + 1);
      case align
        of hold(Right) do
           OP((pat $ len-l), s); break
        of hold(Left) do
           OP(s, (pat $ len-l)); break
        of hold(Center) do
           d1 := len-l; d2 := d1 div 2;
           OP((pat $ d2), s, (pat $ d1-d2));
           break
        otherwise
           error("Illegal alignment")
      end_case
   end_if

end_proc:
