// 

// bij
// creates a random  string
// stringlib::random(<LENGTH>, <CHARACTERS>, <Prefix = "">, <Suffix = "">)


stringlib::random:=
  proc(LENGTH = 7)
    local CHARS, OPT, RAND, PR, SU, check, tmp, allOptions, types;
  begin
    allOptions := table(Prefix="", Suffix="",
                       Name=FALSE, Exclude=[]);
    types := table(Prefix=DOM_STRING, Suffix=DOM_STRING,
                   Name=DOM_BOOL);
    OPT:= prog::getOptions(1, [args()], allOptions, FALSE, types)[1];
    // default value;
    CHARS:= (stringlib::lowerLetters.stringlib::upperLetters.stringlib::digits $ 4).stringlib::punctuation;
    OPT["Length"]:= TRUE;
    OPT["Add"]:= 0;
    if contains({DOM_LIST, DOM_SET}, type(LENGTH)) then
      if {op(map(LENGTH,type))} <> {DOM_STRING} then
        error("illegal argument");
      end_if;
      // list or set of characters
      OPT["Chars"]:= TRUE;
      CHARS:= LENGTH;
      LENGTH:= 7;
    elif type(LENGTH) = DOM_INT or type(LENGTH) = "_range" then
      delete OPT["Length"]; // length explicitly set
      if type(LENGTH) = "_range" then
        OPT["Add"]:= op(LENGTH, 2);
        LENGTH:= op(LENGTH, 1) + random(-_subtract(op(LENGTH)) + 1)();
        OPT["Add"]:= OPT["Add"] - LENGTH // difference to maximum length
      end_if;
      if args(0) > 1 and contains({DOM_LIST, DOM_SET}, type(args(2))) then
        CHARS:= args(2)
      end_if
    else
      LENGTH:= 7 // default
    end_if;
    SU := OPT[Exclude];
    if domtype(SU) = DOM_SET or domtype(SU) = DOM_LIST then
      CHARS := select([op(CHARS)], X -> not has(SU, X));
      if CHARS = [] then
        error("no characters left after exclusion");
      end_if;
    else
      // should not be reached
      error("wrong value for option 'Exclude'")
    end_if;

    // convert to a strings
    PR:= prog::getname(OPT[Prefix]);
    SU:= prog::getname(OPT[Suffix]);

    if LENGTH <= length(PR) then
      if OPT["Add"] + LENGTH > length(PR) then
        [OPT["Add"], LENGTH]:= [OPT["Add"] - (length(PR) + 1 - LENGTH), length(PR) + 1]
      //elif contains(OPT, "Length") then //default length
      //  LENGTH:= length(PR) + 2 // two free characters
      else
        error("Prefix too long or length too small")
      end_if
    end_if;
    if LENGTH <= length(SU) then
      if OPT["Add"] + LENGTH > length(SU) then
        [OPT["Add"], LENGTH]:= [OPT["Add"] - (length(SU) + 1 - LENGTH), length(SU) + 1]
      //elif contains(OPT, "Length") then //default length
      //  LENGTH:= length(PR) + length(SU) + 2 // two free characters
      else
        error("Suffix too long or length too small")
      end_if
    end_if;
    if LENGTH <= length(PR) + length(SU) then
      if OPT["Add"] + LENGTH > length(PR) + length(SU) then
        LENGTH:= random(OPT["Add"] + LENGTH - length(PR) - length(SU))() + 1
      else
        error("Prefix.Suffix too long or length too small")
      end_if
    else
      LENGTH:= LENGTH - length(PR) - length(SU)
    end_if;

    if OPT[Name] = TRUE then
      check:= proc(STR, CHR) // check whether STR contains only characters of CHR
                local k;
                name stringlib::random::check;
              begin
                for k from 1 to length(STR) do
                  if contains(CHR, substring(STR, k)) = 0 then
                    return(FALSE)
                  end_if
                end_for;
                TRUE
              end_proc;
      
      // valid prefix?
      if OPT[Prefix] <> "" then
        if check(PR[1],     stringlib::lowerLetters.stringlib::upperLetters.["_"]) and (length(PR) = 1 or 
           check(PR[2..-1], stringlib::lowerLetters.stringlib::upperLetters.["_"].stringlib::digits)) then
        else
          error("wrong prefix for names")
        end_if
      else // generate prefix
        tmp:= select(CHARS, stringlib::validIdent);
        if tmp <> [] then
          PR:= op(tmp, random(nops(tmp))() + 1);
        else
          PR:= op(stringlib::lowerLetters.stringlib::upperLetters.["_"],
                  random(nops(stringlib::lowerLetters.stringlib::upperLetters.["_"]))() + 1);
        end_if;
        LENGTH:= LENGTH - 1;
      end_if;
      // valid suffix?
      if OPT[Suffix] <> "" then
        if not check(SU, stringlib::lowerLetters.stringlib::upperLetters.["_"].stringlib::digits) then
          error("wrong suffix for names")
        end_if
      end_if;
      // valid characters?
      if contains(OPT, "Chars") then
        if not check(_concat(op(CHARS)), stringlib::lowerLetters.stringlib::upperLetters.["_"].stringlib::digits) then
          error("wrong characters for names")
        end_if
      else
        CHARS:= stringlib::lowerLetters.stringlib::upperLetters.["_"].stringlib::digits
      end_if;
    end_if;

    RAND:= random(nops(CHARS));
    PR._concat(op(CHARS, RAND() + 1) $ OPT = 1..LENGTH).SU
    
  end_proc:
