// 

// bij, 05/2003
//
// readText(FILE, <String, <NoNL, Separator = STRING>>)
// 
// read in a whole file with name FILE or file-descriptor FILE
// return a list of strings, one string per line, newlines are chopped
//
// [default]
//                 return a list of strings, each string per line, newlines are chopped
// String
//                 return a single string, newlines are kept
// NoNL
//                 return a single string without newlines
// Separator = STRING
//                 return a single string with STRING instead of newlines

stringlib::readText :=
  proc(file)
    local FILE, OPT, LINE, RET;
  begin
    if args(0) < 1 then
      error("wrong number of arguments");
    end_if;
    FILE := prog::checkFile(file);
    OPT := prog::getOptions(2, [args()], // skip first parameter
                            table(String    = FALSE,
                                  NoNL      = FALSE,
                                  Separator = "\n"),
                            FALSE,
                            table(String    = DOM_BOOL,
                                  NoNL      = DOM_BOOL,
                                  Separator = DOM_STRING))[1];

    // collect lines, while available
    RET := [];
    file := traperror((while (LINE := ftextinput(FILE)) <> null() do
                         if LINE <> "" and LINE[-1] = "\r" then
                           LINE:= LINE[1..-2];
                         end_if;
                         // a table would be more efficient for files with  many lines
                         RET := append(RET, LINE); 
                       end_while));
      
    prog::checkFile(FILE, hold(Close)); // close the opened file
    if file <> 0 then
      error("failed to read from file '".file."'")
    end_if;

    if OPT[String] then
      if OPT[NoNL] then
        if OPT[Separator] <> "\n" then
          error("options NoNL and Separator can not be combined");
        end_if;
        return(_concat(op(RET)))
      else
        if RET = [] then
          return("");
        end_if;
        return(op(_concat(op(map(RET[1..-2], _concat, OPT[Separator]
                                 )))) . RET[-1])
      end_if
    else
      // list of lines
      return(RET)
    end_if
  end_proc:
