// 

// bij, 05/2002
// split string into several parts

stringlib::split:=
  proc(string : DOM_STRING, separator = " ")
    local indexlist, k, l, T;
  begin
    if args(0) > 3 then
      error("wrong number of arguments");
    end_if;
    if args(0) > 2 and args(3) <> hold(Table) then
      error("illegal option '".expr2text(args(3))."'");      
    end_if;
    if domtype(separator) <> DOM_STRING and domtype(separator) <> DOM_LIST and separator <> hold(Table) then
      error("illegal argument");
    end_if;
    T := bool(args(args(0)) = hold(Table));
    if separator = "" then
      if T then
        return(table([k = string[k] $ k = 1..length(string)]))
      else
        return([string[k] $ k = 1..length(string)])
      end_if
    end_if;
    
    if separator = hold(Table) then
      separator := " "
    end_if;

    if domtype(separator) = DOM_LIST then
      string := stringlib::split(string, separator[1]);
      for l from 2 to nops(separator) do
        for k from 1 to nops(string) do
          string[k] := op(stringlib::split(string[k], separator[l]))
        end_for
      end_for
    else
      indexlist:= stringlib::contains(string, separator, hold(IndexList));
      l := length(separator);
      
      if indexlist <> [] then
        string := [// uncomment to prevent empty strings at begin
                   //(if op(indexlist, 1) > 1 then
                   //   substring(string, 1 .. op(indexlist, 1) - 1)
                   // else
                   //   null()
                   // end_if),
                   substring(string, 1 .. op(indexlist, 1) - 1),
                   substring(string, op(indexlist, k) + l .. op(indexlist, k + 1) - 1)
                     $ k = 1..nops(indexlist) - 1,
                   // uncomment to prevent empty strings at end
                   //(if (l := substring(string, op(indexlist, nops(indexlist)) + l .. length(string))) <> "" then
                   //   l
                   // else
                   //   null()
                   // end_if)
                  substring(string, op(indexlist, nops(indexlist)) + l .. length(string))]
      else
        string := [string]
      end_if
    end_if;

    if T then
      return(table([k = string[k] $ k = 1..nops(string)]))
    else
      return(string)
    end_if
  end_proc:
