/*-

stringlib::subsop -- substitutes substrings

Calling sequence:

stringlib::subsop(s, a=r)
stringlib::subsop(s, a..b=r)

Parameter:

s, r  - strings
a, b  - non-negative integers

Examples:

>> stringlib::subsop("abcdef", 3 = "XX");

                                 "abcXXef"


>> stringlib::subsop("abcdef", 3 = "");
 
                                  "abcef"

>> stringlib::subsop("abcdef", 2..4 = "X");

                                  "abXf"

-*/

stringlib::subsop :=
proc(s, eqn)
  local l, r;
begin
  if args(0) <> 2 then
    error("wrong number of arguments");
  end_if;

  if testargs() then
    if type(s) <> DOM_STRING then
      error("string expected");
    end_if;
    if type(eqn) <> "_equal" then
      error("equation expected");
    end_if;
  end_if;

  l := op(eqn, 1);
  r := op(eqn, 2);
  
  if type(l) = "_range" then
    if testargs() then
      if domtype(lhs(l)) <> DOM_INT or domtype(rhs(l)) <> DOM_INT or lhs(l) < 1 or lhs(l) > rhs(l) or rhs(l) > length(s) then
        error("invalid range");
      end_if;
    end_if;
    s[l] := r;
  else
    if testargs() then
      if domtype(l) <> DOM_INT or l < 1 or l > length(s) then
        error("invalid range");
      end_if;
    end_if;
    s[l..l] := r;
  end_if;
  s;
end_proc:
