
// Pref::warnDeadProcEnv(TRUE):
testargs(TRUE):
alias(bl=matchlib::block):

// patterns for definite summation
//
// global assumptions
// Summationsindex k
// a, b, c, ..., v, w, y, z  sind von k unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted
// px, qx are polynomial expressions
// qx1 is the reciprocal of a polynomial expression
//

default_assumptions :=
map([a,b,c,d,e,f,g,h,i,j,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z],
  v -> subs(bl(not has(`#v`, _X)), `#v`=v)) .
map([m, n, m0, n0, m1, m2, n1, n2],
    v -> subs(bl(testtype(`#v`, Type::PosInt)), `#v`=v)).
[bl(testtype(m2, Type::Even)),     
 bl(testtype(n2, Type::Even)),    
 bl(testtype(m1, Type::Odd)),     
 bl(testtype(n1, Type::Odd)),     
 bl(testtype(n3, Type::Integer)), 
 bl(testtype(m3, Type::Integer)), 
 null()
]:


assumptions :=
proc(pattern)
  local vars;
begin
  vars := indets(pattern) union Type::ConstantIdents union stdlib::PROTECTED union {_X, `#matchlib::block`};
  select(default_assumptions,
         a->indets(a) minus vars = {});
end:

include_assumptions :=
proc(p)
begin
  [p[1], p[2],
   [op(indets(p) minus (Type::ConstantIdents union stdlib::PROTECTED union {_X, `#matchlib::block`}))],
   if nops(p) = 3 then
     p[3]
   else
     []
   end_if,
   assumptions(p[1])];
end_proc:


LEVEL := 1: // spart Zeit beim Einlesen

START := time():

read("patterns_definite.mu"):

// check for errors happening often:
for pat in sum_patterns do
  if domtype(pat) <> DOM_LIST then
    error("Not a list: ".expr2text(pat));
  end_if;
  if nops(pat) > 3 then
    if domtype(pat[4]) <> DOM_LIST then
      error("illegal conditions at ".expr2text(pat[1]));
    end_if;
  end_if;
end_for:


// Creates a definite or indefinite pattern for the pattern matcher
// using an undefinite pattern and a range
// here, the vars have not been renamed yet
// The arguments are:
// pat[1]: The pattern
// pat[2]: The range
// pat[3]: The result
// pat[4]: The conditions
//
createPattern :=
proc(pat)
  local l, r;
begin
  if nops(pat) <> 4 then
    error("pattern ".expr2text(pat)." does not contain 4 elements");
  end_if:
  
  if type(pat[2]) <> "_equal" then
    [pat[1], pat[3], pat[4]] ; // indefinite pattern
  else
    [l, r] := [op(op(pat[2], 2))];
    [`#hdef`(pat[1],l,r), pat[3], pat[4]] ;  // definite pattern
  end_if:  
end_proc:

// constant factors
sum_patterns2 := map(subs(sum_patterns, k=_X),
                  createPattern@sum::addpattern::extractconstantsEx):

print(Unquoted,
      _outputSequence(nops(sum_patterns2),
                      " patterns read in ",
                      (time()-START)/1000.0, " seconds")):


sum_patterns2 := map(sum_patterns2, include_assumptions):

allpatterns := []:
matchlib::addpatterns(sum::patternFSA, allpatterns, sum_patterns2,
	                    sum::addpattern::generalize, 5000, FAIL):


print(Unquoted,
      _outputSequence("compilation finished, ", (time()-START)/1000.0, " seconds")):
               
bytes();

if doNotSavePatterns <> TRUE then
  patternFSA := sum::patternFSA;
  write("patternFSA.mb", patternFSA);
end_if:

