
// products w.r.t. a to-be-generated ident:
sum::product :=
proc(a, r)
   local i;
begin
   i := solvelib::getIdent(Z_, indets(a) union indets(r));
   product(a(i), i=r);
end_proc:

/*

Calling sequence:

sum::indefinite(f, x <,"LookupOnly">)

The "option"" "LookupOnly" is undocumented, because it should be only used
internally. It means only the lookup mechanism should be used.

*/
// returns h such that h(x+1)-h(x)=f(x) 
sum::indefinite:=
proc(f,x)
  local prod, summe, C, lookupOnly, l, sums, nonsums ;
  save _X ; // if assumption becomes necessary for the summation index
begin
  userinfo(1,"entering indefinite summation");

  if args(args(0)) = "LookupOnly" then
    lookupOnly:= TRUE ;
  else
    lookupOnly:= FALSE ;
  end_if;
  
  // handle ln separately
  if type(f) = "ln" then
    // use sum(ln(g(n)), n) = ln(product(g(n), n))
    prod:= product(op(f, 1), x);
    if type(prod) <> "product" then
      return(ln(prod))
    end_if;
  end_if;
  // first: expand all factorials
  f:= misc::maprec(f, {"fact"} = expand);
  if testtype(f,Type::PolyExpr(x,Type::AnyType)) then
    return(sum::poly(f,x))
  elif testtype(f,Type::RatExpr(x,Type::AnyType)) then
    // do not use properties in this step
    save x;
    unassume(x);
    return(sum::rat(f,x))
  elif type(f) = "_plus" and nops(f) = 2 then
    if subs(op(f, 1), x = x - 1) = -op(f, 2) then
       // f(x) is syntactically  h(x + 1) - h(x)
      return(-op(f, 2))
    elif subs(op(f, 1), x = x + 1) = -op(f, 2) then
       // f(x) is syntactically  h(x) - h(x + 1)
      return(-op(f, 1))
    end_if
  end_if;

  
  // Before usign the Gosper algorithm we will try to use
  // a pattern matcher for finding the solution
  C:=genident() ;
  /* At the moment we do not use properties for the summation index 
  if property::hasprop(_X) then
    zip([C],[getprop(_X)],assume);
  end_if;
  */
  delete _X;
  if x<>_X then f:=subs(f,[_X=C,x=_X]) end_if;
  
  userinfo(2,"trying the lookup method for indefinite summation");
  summe:=sum::lookup(f, _X, NIL, NIL);
  if summe<>FAIL then
    summe:=subs(summe, [_X=x,C=_X]) ;
    return(summe) ;
  else
    f:=subs(f, [_X=x,C=_X]) ;
  end_if;
  if lookupOnly then
    return(hold(sum)(f, x)) ;
  end_if:

  // expand sums
  if type(f) = "_plus" then
    l:= map([op(f)], sum::indefinite, x);
    [sums, nonsums, C]:= split(l, X -> type(X) = "sum");
    assert(C= []);
    // write sum(f1, n) + sum(f2, n)  as sum(f1+f2, n)
    sums:= _plus(op(map(sums, op, 1)));
    if iszero(sums) then
      return(_plus(op(nonsums)))
    else
      return(sum::gosper(f,x));
    end_if
  end_if;
  
  return(sum::gosper(f,x))
end_proc:

