

// CHANGED (jngerhar, 28.9.00)
// Try to compute limit(f, x = a) without using limit if possible, since
// limit is often much much too slow when f contains parameters.
sum::myeval :=
proc(f, x, a)
  local ff, fa, ord, t, j;
begin
  if type(f) = piecewise then 
    if domtype(a) <> stdlib::Infinity then
      f:= piecewise::mapConditions(f, subs, x=a);
      if type(f) = piecewise then
        return(piecewise::extmap(f, sum::myeval, x, a))
      end_if
    else
	return(limit(f, x = a, Real, NoWarning))
    end_if
  end_if;

  assert(type(f) <> piecewise);  

  ff := expr(factor(f));
  // first try subs. If we get fa = 0 we can have a 0/0 situatio
  if domtype(a) <> stdlib::Infinity
    and traperror((fa := subs(ff, x = a, EvalChanges))) = 0 and fa <> 0 then
    // rewrite all binomials
      fa:= misc::maprec(fa, {"binomial"} =
                        proc(b)
                          local n, k;
                        begin
                          n:= op(b, 1);
                          k:= op(b, 2);
                          if testtype(k, Type::NonNegInt) then
                            _mult((n-j+1)/j $j=1..k)
                          elif testtype(n-k, Type::NegInt) then
                            0
                          else
                            b
                          end_if
                        end_proc
                        );
      return(eval(expr(factor(fa))))
  else
    save x ;
    unassume(x);
    // next try series with orders 1,2,3,4
    for ord from 1 to 4 do
      if traperror((fa := series(ff, x = a, ord, Real, NoWarning))) = 0 then
        if domtype(fa) = Series::Puiseux or domtype(fa) = Series::gseries then
          // expand is necessary to simplify products of gammas. This
          // was formerly done by series.
          // combine is necessary to cancel, e.g., 2^x/2^x
          if (t := lmonomial(fa)) <> FAIL then
            t := eval(expr(factor(expand(combine(rewrite(t, gamma))))));
            if not has(t, x) then
              return(t);
            else
              break;
            end_if
          end_if
        elif type(fa) = "series" then
          break;
        end_if;
      end_if;
    end_for;
  end_if;
  // Finally, use limit as a last resort
  // We only come to this point if we was in the else case before, so x
  // is already saved and its assumptions are removed
  t:= limit(ff, x = a, Real, NoWarning);
  if type(a) <> stdlib::Infinity and has(t, infinity) then
    error("Singularity")
  else
    t
  end_if
end_proc:

