// Globale Annahmen:
//
// ACHTUNG diese globalen Annahmen sind extrem wichtig bei der
// Konstruktion der Pattern. Dieser Kommentarblock ist daher unbedingt auf
// dem aktuellen Stand zu halten!
//
// Summationsvariable k
// a, b, c, ..., v, w, x, y, z sind von k unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// fx, gx, f1x, g1x are unrestricted

// Diese Datei wird aus compile_patterns_definite.mu heraus gelesen.

sum_patterns:=
[
 /*
  [fx*hold(kroneckerDelta)(a*k + b, c*k + d), k = 0..infinity,
    bl(piecewise([(d - b)/(a - c) in Z_ and (d - b)/(a - c) >=0, 
                  sum::evalAtPoint(fx, k, (d - b)/(a - c))],
                 [Otherwise, 0])), 
    [bl(not iszero(a - c))]],
  [fx*hold(kroneckerDelta)(a*k + b, 0*k + d), k = 0..infinity,
    bl(piecewise([(d - b)/(a - 0) in Z_ and (d - b)/(a - 0) >=0, 
                  sum::evalAtPoint(fx, k, (d - b)/(a - 0))],
                 [Otherwise, 0])), 
    [bl(not iszero(a - 0))]],
  [fx*hold(kroneckerDelta)(0*k + b, c*k + d), k = 0..infinity,
    bl(piecewise([(d - b)/(0 - c) in Z_ and (d - b)/(0 - c) >=0, 
                  sum::evalAtPoint(fx, k, (d - b)/(0 - c))],
                 [Otherwise, 0])), 
    [bl(not iszero(a - c))]],
  */
  [a^k*x^k, k=0..infinity, -1/(a*x-1), [bl(abs(a*x) < 1)]
   ],
  [a^k*x^k, k=0..infinity, infinity,  [bl(a*x >= 1)]
   ],
  [a^k*x^k, k=0..infinity, bl(`#undefined`),  [bl(a*x <= -1)]
   ],
   [fx*kroneckerDelta(a*k + b, 0)^c, k = 0..infinity,
    bl(piecewise([-b/a in Z_ and -b/a >= 0, 
                  sum::evalAtPoint(fx, k, - b/a)],
                 [Otherwise, 0])),
    [bl(not iszero(a)), bl(testtype(c, DOM_INT) and c > 0)]],
 
   [fx*kroneckerDelta(a*k + b, 0)^c, k = u..v,
    bl(piecewise([-b/a in Z_ and a*v+b >= 0 and a*u+b <= 0, 
                  sum::evalAtPoint(fx, k, - b/a)],
                 [Otherwise, 0])),
    [bl(not iszero(a)), bl(testtype(c, DOM_INT) and c > 0)]],
  // Special sums with cos() and sin()
  // Here we have a and b are integers and |x| < infinity
  [((-1)^k * a^(2*k+1) * x^(2*k+1)) / (b^(2*k+1) * (2*k+1)!) , 
   k = 0..infinity, sin(a/b*x), [bl(not iszero(a)), bl(not iszero(b))]],
  [(-1)^(k-1) * 2^(2*k-1) * x^(2*k) / (2*k)! , k=1..infinity,  sin(x)^2],
  [(-1)^(k-1) * (3^(2*k+1)-3) * x^(2*k+1) / (2*k+1)! , k=1..infinity,
   sin(x)^3 * 4],
  [((-1)^k * a^(2*k) * x^(2*k)) / (b^(2*k) * (2*k)!) , k=0..infinity,
    cos(a/b * x), [bl(not iszero(a)), bl(not iszero(b))]],
  [(-1)^k * 2^(2*k-1) * x^(2*k) / (2*k)! , k=1..infinity, cos(x)^2 - 1],
  [(-1)^k * (3^(2*k)+3) * x^(2*k) / (2*k)! , k=0..infinity, cos(x)^3 * 4],
  // Special sums using bernoulli, with "piecewise"" results
  [2^(2*k)*(2^(2*k)-1)/(2*k)! * (-1)^(k+1) * bernoulli(2*k) * x^(2*k-1),
   k=1..infinity, bl(tan(x)), [abs(x) < PI/2]],
  [2^(2*k)/(2*k)! * (-1)^k * bernoulli(2*k) * x^(2*k-1), k=1..infinity,
   bl(cot(x) - 1/x), [abs(x) < PI]],
  [2*(2^(2*k-1)-1)/(2*k)! * (-1)^(k-1) * bernoulli(2*k) * x^(2*k-1),
   k=1..infinity, bl(csc(x) - 1/x), [abs(x) < PI]],
  // euler(n) bezeichnet die n-te Euler-Zahl
  // Diese Funktion existiert in MuPAD nicht
  //[(-1)^k * euler(2*k) * x^(2*k) / (2*k)!, k=0..infinity,
  // bl(piecewise([abs(x) < PI/2, sec(x)]))],
  // Reihen der zyklometrischen Funktionen
  [binomial(-1/2, k) * (-1)^k * x^(2*k+1)/(2*k+1), k=0..infinity,
   bl(arcsin(x)), [abs(x) < 1]],
  [(-1)^k * x^(2*k+1)/(2*k+1), k=0..infinity,
   bl(arctan(x)), [abs(x) < 1]],
  // Reihen der Hyperbelfunktionen
  // The following holds for |x| < infinity
  [x^(2*k+1)/(2*k+1)!, k=0..infinity, sinh(x)],
  [2^(2*k-1)*x^(2*k)/(2*k)!, k=1..infinity, sinh(x)^2 ],
  [(3^(2*k+1)-3)*x^(2*k+1)/(2*k+1)!, k=1..infinity, sinh(x)^3 * 4],
  [x^(2*k)/(2*k)!, k=0..infinity, cosh(x)],
  [(3^(2*k)+3)*x^(2*k)/(2*k)!, k=0..infinity, cosh(x)^3 * 4],
  //
  [2^(2*k)*(2^(2*k)-1)*bernoulli(2*k)*x^(2*k-1)/(2*k)!, k=1..infinity,
   bl(tanh(x)), [abs(x) < PI/2]],
  [2^(2*k)*bernoulli(2*k)*x^(2*k-1)/(2*k)!, k=1..infinity,
   bl(coth(x) - 1/x), [abs(x) < PI]],
  [2*(2^(2*k-1)-1)*bernoulli(2*k)*x^(2*k-1)/(2*k)!, k=1..infinity,
   bl(1/x - csch(x)), [abs(x) < PI]],
  // euler(n) bezeichnet die n-te Euler-Zahl
  // Diese Funktion existiert in MuPAD nicht
  //[euler(2*k)*x^(2*k)/(2*k)!, k=0..infinity,
  // bl(piecewise([abs(x) < PI/2, 1/x - sech(x)]))],
  //
  // Reihen der inversen Hyperbelfunktionen
  [binomial(-1/2, k) * x^(2*k+1)/(2*k+1), k=0..infinity,
   bl(arcsinh(x)), [abs(x) < 1]],
  [x^(2*k+1)/(2*k+1),k=0..infinity,
   bl(arctanh(x)), [abs(x) < 1]],
  [x^(a*k+b)/(c*k + d),k=0..infinity,
   bl(x^(b - d/c*a)/c *2*arctanh(x^(a/2))
      -sum::sum_fn((k -> x^(a*k+b)/(c*k + d)) , 1/2 - d/c .. -1)),
   [(a > 0 and abs(x) < 1) or (a < 0 and abs(x) > 1),
     d/c >= 0, (d/c - 1/2) in Z_]
  ],
  [x^(a*k+b)/(c*k + d),k=0..infinity,
   bl(x^(b - d/c*a)/c * 2*arctanh(x^(a/2))
      +sum::sum_fn((k -> x^(a*k+b)/(c*k + d)) , 0 .. - d/c - 1/2)),
   [(a > 0 and abs(x) < 1) or (a < 0 and abs(x) > 1),
    d/c < 0, (d/c - 1/2) in Z_]
  ],
  // Bernoulli Numbers
  //[1/(l+1)*sum((-1)^k*binomial(l,k)*k^n,k=0..l),
  // bl(piecewise([n in Z_ and n > 0, bernoulli(n)]))],
  // We do not need this pattern because the polylog pattern below
  // will do the job in a much better way
  // [1/k^(2*n),k=1..infinity,
  //  bl(piecewise([n in Z_ and n > 0, bernoulli(2*n) * (2*PI)^(2*n) /
  //                                   ((-1)^(n-1)*2*(2*n)!)]))],
  // Folgendes Pattern ist problematisch bzgl. zeta(n),
  // daher sollte es nicht benutzt werden. 
  //[1/k^n*cos(PI*n/2),k=1..infinity,
  // bl(piecewise([n in Z_ and n > 1, bernoulli(n) * (2*PI)^n / (-2*n!)]))],
  // Euler numbers
  // euler(n) bezeichnet die n-te Euler-Zahl
  // Diese Funktion existiert in MuPAD nicht
  //[(-1)^k/(2*k+1)^(2*n+1),k=0..infinity,
  // bl(piecewise([n in Z_ and n >= 0, euler(2*n) * ((-1)^n*2^(2*n+2)*(2*n)!)/PI^(2*n+1)]))],
  //[1/(2*k+1)^(n+1)*cos(k*PI-PI*n/2),k=0..infinity,
  // bl(piecewise([n in Z_ and n > 1, euler(n) * (2^(n+2)*n!) / PI^(n+1)]))],
  // Riemann zeta function TODO
  //[1/2^(n+1)*sum(binomial(n,k)*(-1)^k/(k+1)^s,k=0..n),n=0..infinity,
  // zeta(s) * (1-2^(1-s))],
  // "We have"" to use the picewise here to get some nicer results
  // because otherwise the polylog patterns will also lead to a result
  // and at the moment piecewise is not smart enough to handle this
  //[k^(-z), k=1..infinity, bl(zeta(z)), [Re(z) > 1]],
  [k^(-z), k=1..infinity, bl(piecewise([Re(z) > 1,zeta(z) ]))],
  //
  // Polylogarithm function
  [a^(b*k + c)*x^(d*k + e)/k^v, k=1..infinity,
   bl(a^c*x^e*polylog(v, a^b*x^d)),
   [bl(not iszero(a)), abs(a^b*x^d) <= 1, v in Z_, v > 1]
  ],
  [a^(b*k + c)*x^(d*k + e)/k^v, k=1..infinity,
   bl(a^c*x^e*polylog(v, a^b*x^d)),
   [bl(not iszero(a)), abs(a^b*x^d) <= 1, x^d <> a^(-b), v = 1] 
  ],
  [a^(b*k + c)*x^(d*k + e)/k^v, k=1..infinity,
   bl(a^c*x^e*polylog(v, a^b*x^d)),
   [bl(not iszero(a)), abs(a^b*x^d) < 1, v in Z_, v < 0]
  ],
  [x^k/k, k=1..infinity,
   bl(infinity),
   [x >= 1]
  ],
  // 
  // Dilogarithm function
  // "We have"" to use the picewise here to get some nicer results
  // because otherwise the polylog patterns will also lead to a result
  // and at the moment piecewise is not smart enough to handle this
  [x^k/k^2, k=1..infinity, bl(piecewise([abs(x) <= 1, dilog(1-x)]))],
  [(1-x)^k/k^2, k=1..infinity, bl(piecewise([abs(1-x) <= 1, dilog(x)]))],
  //
  // Error function
  [(-1)^k*z^(2*k+1)/(k!*(2*k+1)),k=0..infinity, erf(z) * sqrt(PI)/2],
  //
  // Gamma function
  [(D@@k)(gamma)(1)*z^k/k!,k=0..infinity,
   bl(gamma(z) * z), [abs(z) < 1]],
  //
  // Incomplete Gamma function
  [(w)^k*(z)^k/((a+k)*k!),k=0..infinity,
   bl((igamma(a, -w*z) - gamma(a))/((-w*z)^a)),
   [bl(not iszero(a)), bl(not iszero(w)), bl(not iszero(z))]],
  // The following does not work for -z, because if k is an integer
  // the kernel rewrites (-z)^k to (-1)^k*z^k which at the moment
  // leads to problems 
  //[(-z)^k/((a+k)*k!),k=0..infinity, bl(( igamma(a, z) - gamma(a) ) / (-z^a))],  //
  // Exponential Integral
  [(-1)^(k-1)*z^k/(k*k!),k=1..infinity, bl(Ei(z) + EULER + ln(z))],
  // Sine Integral
  [(-1)^(k-1)*z^(2*k-1)/((2*k-1)*(2*k-1)!),k=1..infinity, Si(z)],
  // Cosine Integral
  [(-1)^k*z^(2*k)/((2*k)*(2*k)!),k=1..infinity, bl(Ci(z) - EULER - ln(z))],
  // Exponential Fourier series
  [(-1)^k*k*sin(k*x)/(k^2-a^2), k=1..infinity,
   bl(sin(a*x) * PI / (-2*sin(a*PI))), [not (a in Z_), -PI < x < PI]],
  // 
  [1/(1+ k^2*PI^2), k=1..infinity, 1/2*coth(1) - 1/2],
  [binomial(l, k)/k!, k=0..l,
   bl(hypergeom([-l],[1],-1)), [l in Z_ , l > 0]],
  [binomial(l, k)/k!, k=0..infinity,
   bl(exp(-1/2)*( (1+l)*whittakerM(-l, 1/2, 1) 
                 +(1-l)*whittakerM(1-l,1/2, 1)))],

  // various further patterns
  [(-1)^k*exp(k*x)/k!, k = 0..infinity, bl( exp(-exp(x)))],
  [(-1)^k*sin(k*x)/k!, k = 0..infinity, bl(-sin(sin(x))*exp(-cos(x)))],
  [(-1)^k*cos(k*x)/k!, k = 0..infinity, bl( cos(sin(x))*exp(-cos(x)))],

  // special cases for hypergeometric summation
  [0^(a-k)/k!/(a-k)!, k = 0..a, bl(1/a!)],
  [a!*x^(a-k)/k!/(a-k)!, k=0..a, bl((x+1)^a)],
  [binomial(a, k)*x^(a-k), k=0..a, (x + 1)^a],
  [gamma(a+1)/(gamma(k+1)*gamma(a-k+1))*x^(a-k), k=0..a, (x + 1)^a],
  // indefinite patterns
  // special cases for hypergeometric summation
  [0^(a-k), k, 0^(a+1-k)],
 null()
]:
