// p is a polynom in x, returns h such that p = eval(subs(h,x=x+1))-h 
sum::poly := proc(p,x)
local d,i,b,a;
begin
  if not has(p,x) then p*x
  else // method of indeterminate coefficients 
   p:=poly(p,[x]); d:=degree(p);
   // first tabulate a[i]=(x+1)^i 
   a[1]:=poly(x+1,[x]); for i from 2 to d+1 do a[i]:=a[1]*a[i-1] end_for;
   for i from d+1 downto 2 do
      b[i]:=coeff(p,i-1)/i;
      p:=p+multcoeffs(lmonomial(a[i],Rem)[2],-b[i]);
   end_for;
   b[1]:=coeff(p,0);
   _plus(b[i]*x^i $ i=1..d+1)
  end_if
end_proc:
