sum::rat := proc(f,x)
local num,den,d,dnum,dden;
begin
   num:=numer(f); den:=denom(f);
   dnum:=degree(num,x); dden:=degree(den,x);
   if dnum>=dden then
      if traperror( (d:=divide(poly(num,[x]),poly(den,[x]))) ) <> 0 then
        hold(sum)(f,x);
      else
        sum::poly(expr(d[1]),x)+sum::rat(expr(d[2])/den,x);
      end_if;
   else // now deg(num)<deg(den) 
      d:=sum::rat_abramov(f,x);
      if d=FAIL then hold(sum)(f,x) else d end_if
   end_if
end_proc:

sum::rat_abramov :=
proc(f,x)
begin
   userinfo(1,"entering Abramov's algorithm");
   sum::abr(f, sum::dispersion(denom(normal(f)),x),x)
end_proc:

sum::abr :=
proc(f,dis,x)
  local p,q,cp,vwp,vwm,ba,u,newf;
begin
  userinfo(2,"dispersion=",dis);
  if f=0 then
    return(0)
  end_if;
  if dis=0 then
    return(sum::to_psi(f,x))
  end_if;
  p:=numer(f); q:=denom(f);
  cp:=gcd(q,subs(q,x=x+dis));
  if cp=1 then return(sum::abr(f,dis-1,x)) end:
  vwp:=sum::abr_part(q,cp, x);
  vwm:=sum::abr_part(q,subs(cp,x=x-dis), x);
  if degree(vwm[1],x)>degree(vwp[1],x) then
    ba:=solvelib::pdioe(vwp,p,x);
    u:=subs(ba[2]/vwp[1],x=x-1);
    newf:=normal(ba[1]/vwp[2]+u);
  else
    ba:=solvelib::pdioe(vwm,p,x);
    u:=-ba[2]/vwm[1];
    newf:=normal(ba[1]/vwm[2]+subs(ba[2]/vwm[1],x=x+1))
  end_if;
  u+sum::abr(newf,dis-1,x)
end_proc:

sum::abr_part :=
proc(p, h, x: DOM_IDENT)
  local g,v,w;
begin
  p:= poly(p, [x]);
  h:= poly(h, [x]);
  g:=gcd(p,h); v:=poly(1, [x]); w:=p;
  while degree(g) > 0 do
    w:=divide(w,g,Quo);
    v:=v*g;
    g:=gcd(w,v)
  end_while;
  expr(v), expr(w)
end_proc:

/* f is minimal : sum(f,x) can not be written p+sum(r,x)
  where p is a polynomial and denom(r) has lower degree than denom(f)
*/
sum::to_psi :=
proc(f,x)
  local ff,t,s,a,d,lin;
begin
  ff:=partfrac(f,x, Full);
  userinfo(3,"full partial fraction decomposition=",ff);
  if type(ff)="_plus" then
    ff:=[op(ff)]
  else
    ff:=[ff]
  end_if;
  s:=0;
  for t in ff do
    d:= denom(t);
    d:=d/maprat(d,proc() begin content(args(1),[x]) end_proc );
// primpart(d,[x]) expands too !!!
    if type(d)="_power" and testtype(op(d,2),Type::NonNegInt) then
      lin:=op(d,1)
    else
      lin:=d
    end_if;
    if testtype(lin,Type::PolyExpr(x,Type::AnyType)) then
      case degree(lin,[x])
        of 1 do
          a:=coeff(lin,[x],0)/coeff(lin,[x],1);
          s:=s+subs(sum::to_psi2(normal(subs(t,x=x-a,EvalChanges)),x),x=x+a);
          break;
        otherwise
          return(FAIL)
      end_case
    else // non polynomial
      return(FAIL)
    end_if
  end_for;
  s
end_proc:

sum::to_psi2 :=
proc(f,x) // the denominator looks like a*x^j 
// f must be in normal form 
local n,j,res,d,c,dd,t;
begin
   res:=0;
   d:=denom(f);
   c:=maprat(d,proc() begin content(args(1),[x]) end_proc );
   d:=normal(d/c); // should be given by primpart 
   if d=-x then d:=x; c:=-c end_if;
   if not ((d=x) or (type(d)="_power" and op(d,1)=x and type(op(d,2))=DOM_INT))
   then return(FAIL) // should not happen 
   end_if;
   dd:=degree(d,x)-1;
   n:=numer(f);
   if type(n)="_plus" then n:=[op(n)] else n:=[n] end_if;
   for t in n do
      j:=dd-degree(t,x);
      res:=res+maprat(t,proc() begin lcoeff(args(1),[x]) end_proc )/c*(-1)^j/fact(j)*psi(x,j);
   end_for;
   res
end_proc:

