/*
     sum::rootOf(p, k, f)
     returns \sum_{k \in C_; p(k) = 0} f(k)

*/

sum::rootOf:=
proc(p: RootOf, k, f)
  local z, q, lin;
begin
  z:=op(p,2);
  q:=subs(op(p,1),z = k, EvalChanges);
  // sum(..., x=RootOf(1, y)) simplifies to zero
  if contains({DOM_INT,DOM_RAT},type(q)) then
    return(0)
  end_if;
  if testtype(f, Type::RatExpr(k)) then
// first simplify to a sum over a polynomial
    userinfo(2,"summand is rational");
    f:= stdlib::RootOf_evala(f,q,k)
  end_if;
  if testtype(f,Type::PolyExpr(k)) then // evaluate
    f:= stdlib::RootOf_polysum(f,q,k)
  elif (lin:= Type::Linear(q, [k])) <> FALSE then
    // we have to sum f(k) over all roots of lin[1]*k + lin[2]
    // if lin[1] = lin[2] = 0, this is not defined
    // if lin[1] = 0 and lin[2] <>0, this is zero
    // if lin[1] <> 0, this is f(-lin[2]/lin[1])
    return(piecewise
           (
            [lin[1] = 0 and lin[2] <> 0, 0],
            [lin[1] <> 0, (f | k= -lin[2]/lin[1])]
            )
           )
  else
    f:= FAIL // hold(sum)(args())
  end_if;
  f
end_proc:
