// returns a..b such that f=0 for j<a or j>b 
sum::support :=
proc(f,j)
  local a,b,x,k,c,d;
begin
  a:=-infinity; b:=infinity;
  for x in misc::subExpressions(f,"binomial") do
    for k in [op(x,2),op(x,1)-op(x,2)] do
         // k must be >= 0 
      if testtype(k,Type::PolyExpr(j)) then
        if degree(k,[j])=1 then
          d:=coeff(k,[j],1); c:=-coeff(k,[j],0)/d;
          if is(d>0) then
            if a=-infinity then
              a:=c
            else
              a:=max(a,c)
            end_if
          elif is(d<0) then
            if b=infinity then
              b:=c
            else
              b:=min(b,c)
            end_if
          end_if
        end_if
      end_if
    end_for
  end_for;
  a..b
end_proc:

