

alias(bl=matchlib::block):

transform::fourier::addpattern :=
proc(pattern, varin, varout, result, pat_vars, conds)
  option hold;
  save _X, _Y;
begin
  pattern := context(pattern);
  varin := context(varin);
  varout := context(varout);
  result := context(hold(matchlib::block)(result));
  if args(0) > 4 then
    pat_vars := context(pat_vars);
  else
    pat_vars := [];
  end_if;
  if args(0) > 5 then
    conds := context(hold(map)(hold(hold)(conds), matchlib::block));
  else
    conds := [];
  end;
  if domtype(conds) <> DOM_LIST then conds := [conds]; end_if;

  if varin = varout then
    error("Can't handle identical inout/output variables");
  end_if;

  unprotect(_X);
  unprotect(_Y);
  delete _X, _Y;

  if varout <> _Y and has([pattern, result, pat_vars, varin, conds], _Y) then
    [pattern, result, pat_vars, varin, conds] := 
      subs([pattern, result, pat_vars, varin, conds], _Y=genident("_Y"));
  end;
  [pattern, result, pat_vars, varin, conds] :=
    subs([pattern, result, pat_vars, varin, conds], varout = _Y);
    
  if varin <> _X and has([pattern, result, pat_vars, varout, conds], _X) then
    [pattern, result, pat_vars, varout, conds] := 
      subs([pattern, result, pat_vars, varout, conds], _X=genident("_X"));
  end;
  [pattern, result, pat_vars, conds] :=
  sum::addpattern::extractconstants( subs([pattern, result], varin = _X)).
                                     subs([pat_vars, conds], varin = _X);


  matchlib::addpatterns(transform::fourier::userpatternsFSA,
                        transform::fourier::userpatterns,
                            [[pattern, result, pat_vars, conds,
                              map(pat_vars, v -> subs(bl(not has(`#v`, _X)), `#v`=v))]],
                            transform::fourier::addpattern::generalizesum, FALSE, FAIL);

  null();
end:

transform::fourier::addpattern := funcenv(transform::fourier::addpattern):


// for patterns matching a _plus expression, add `#hx`
// to the pattern and transform::fourier(`#hx`, t, s) to the result:
transform::fourier::addpattern::generalizesum :=
p -> ((if type(p[1])="_plus" then
                            [p[1]+`##`(`#hx`),
                             subsop(p[2], 2=
                             (bl@(x->x))
                             (hold(_plus)(matchlib::unblock(p[2])[2],
                                          hold(transform::fourier(`#hx`, _X, _Y)))))
                            ].p[3..-1]
                          else p end_if)):


/* ======= coincides with sum::addpattern::extractconstants ======
// here the pattern variable is _X
// The arguments are:
// pat[1]: The pattern
// pat[2]: The result
//
transform::fourier::addpattern::extractconstants :=
proc(pat)
  local pat1, noX, dummy;
begin
  if type(pat[1]) = "_mult" then
    [pat1, noX, dummy] := split([op(pat[1])],
                                has, hold([_X, fx, gx, f1x, g1x, px, qx, qx1]));
    noX := _mult(op(noX));
    if noX <> 1 then
      [_mult(op(pat1)),
       subs(matchlib::block(`#a`/`#b`),
            `#a`=matchlib::unblock(pat[2]),
            `#b`=noX)];
    else
      pat;
    end_if;
  else
    pat
  end_if;
end_proc:

======================================================= */

