alias( fourier = transform::fourier ):

fourier:=newDomain("transform::fourier"):
fourier::create_dom:=hold(transform::fourier):
fourier::type:="transform::fourier":

fourier::has:=proc() local T, v;
begin
  T:=args(1); v:=args(2);
  bool( v=extop(T,2) or v=extop(T,3) or 
        has(extop(T,1), v) or v=hold(fourier)
  )
end_proc:

fourier::new:=proc(_f, var1, var2)
   local back;
begin

  if testargs() then
    if args(0)<>3 then error("wrong number of arguments") end_if;
 
    if domtype(_f)<>DOM_EXPR and domtype(_f)<>DOM_IDENT and
       not testtype(_f,Type::Numeric) and type(_f)<>"transform::invfourier" then
         error("first argument of wrong type");
    end_if;
    if domtype(var1)<>DOM_IDENT then
      error("second and third argument must be from type DOM_IDENT");
    end_if;
  end_if;

  if type(_f)="transform::invfourier" then
    return(subs(extop(_f,1), extop(_f,2)=var2))
  end_if;

  back:=fourier::compute(_f, var1, var2);
 
  if back=FAIL then
    return(new(fourier, _f, var1, var2))
  else
    return(back)
  end_if;
end_proc:


fourier::print:=proc(T)
begin
  hold(fourier)(extop(T,1), extop(T,2), extop(T,3));
end_proc:

//this part computes the exponentianal fourier transform
fourier::compute:=proc(_g, var1, var2) local _f, back, typ, i;
begin 
 
  _f:=_g;
  if not has(_f, var1) then
    userinfo(3, "formula 13 from Foellinger");
    return( _f*2*PI*dirac(var2) );
  elif _f=var1 then
    userinfo(3, "formula form M&P");
    return( 2*PI*I*diff(dirac(var2),var2) );
  end_if;

  typ:=type(_f);

  if typ="_equal" then
    return(_equal(fourier(op(_f,1), var1, var2),
            fourier(op(_f,2), var1, var2)))
  end_if;

  if typ="_mult" or typ="_plus" then
    back:=transform::IntTrans::linear(new(fourier, _f, var1, var2));
    if not (back=FAIL) then
      return(back);
    end_if;
  end_if;

/*
  if typ="_mult" and type(op(_f,1))="_power" and type(op(_f,2))="_plus" then
    if op(op(_f,1),2)<0 then
      back:=_plus(
          fourier( op(op(_f,2), i)*op(_f, 1), var1, var2)
             $ i=1..nops(op(_f,2)));
    end_if;
    if back<>FAIL then return(back) end_if;
  end_if;
*/
  if typ="function" and type(op(_f,0))="D" then
    _f:=transform::IntTrans::D2diff(_f);
  end_if;

  back:=transform::IntTrans::builtin(new(fourier, _f, var1, var2));
  if not (back=FAIL) then
    return(back);
  end_if;

  if typ="_mult" and type(op(_f,1))="_power" and type(op(_f,2))="_plus" then
    if op(op(_f,1),2)<0 then
      back:=_plus(
          fourier( op(op(_f,2), i)*op(_f, 1), var1, var2)
             $ i=1..nops(op(_f,2)));
    end_if;
    if back<>FAIL then
      return(back)
    end_if;
  end_if;

 return(FAIL);
end_proc:


fourier::diff:=proc() local i, _f, _t, nps;
begin
/*
  nps:=args(0);
  if nps<2 then
    error("wrong number of arguments")
  end_if;
  _f:=args(1); _t:=args(2);
  if _and(_equal(_t, args(i)) $ i=2..nps,_t=extop(_f,3)) then
    return(fourier((-1*_t)^(nps-1)*extop(_f, 1),extop(_f,2),extop(_f,3) ))
  elif _and(has(_f, args(i)) $ i=2..nps) then
    return( fourier(diff(extop(_f, 1), args(i) $ i=2..nps), 
      extop(_f, 2), extop(_f, 3)))
  else
    return(0);
  end_if;
*/
  FAIL;
end_proc:


fourier::int:=proc() local _F, _f, _a, _b, _t, var1, var2;
begin
/*
  _F:=args(1); _t:=op(args(2),1); _a:=op(op(args(2),2),1); _b:=op(op(args(2),2),2);
  _f:=extop(_F,1); var1:=extop(_F,2); var2:=extop(_F,3);
  if _t=var2 and _a=0 and _b=infinity then
    return(_F/var1)
  end_if;
  hold(int)(_F, _t=_a.._b);
*/
  FAIL;
end_proc:

cos:= slot( cos, "transform::fourier",
    loadproc(slot( cos, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_cos"
    )
):

diff:= slot( diff, "transform::fourier",
    loadproc(slot( diff, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_diff"
    )
):

dirac:= slot( dirac, "transform::fourier",
    loadproc(slot( dirac, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_dirac"
    )
):

exp:= slot( exp, "transform::fourier",
    loadproc(slot( exp, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_exp"
    )
):

heaviside:= slot( heaviside, "transform::fourier",
    loadproc(slot( heaviside, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_heavis"
    )
):

_mult:= slot( _mult, "transform::fourier",
    loadproc(slot( _mult, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_mult"
    )
):

_power:= slot( _power, "transform::fourier",
    loadproc(slot( _power, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_power"
    )
):

sign:= slot( sign, "transform::fourier",
    loadproc(slot( sign, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_sign"
    )
):

sin:= slot( sin, "transform::fourier",
    loadproc(slot( sin, "transform::fourier"),
        pathname("TRANS","FOURIER"), "F_sin"
    )
):

unalias( fourier ):

// end of file 
