// Globale Annahmen:
// Variable der Originalfunktion: t
// Variable der Transformierten:  s
// a, b, c, ..., v, w, y sind von t unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted

// Diese Datei wird aus compile_patterns.mu heraus gelesen.

alias(bl=matchlib::block):

fourier_patterns:=
[// Special cases for heaviside: when d = -a in 
 // a*heaviside(b*t + c) + d*heaviside(e*t + f),
 // then the transform does not contain dirac.
 // Further, there are simplified expressions for
 // the special case f/e = - c/b in terms of sin/cos
 // instead of exp.
 // We implement these special cases here. The generic
 // case is dealt with by the generic fourier code.
 [a*heaviside(b*t + c) - a*heaviside(e*t + f), 
  /* Here is a 'complex' exponential version:
  bl(  I*a*sign(b)*exp(-c*s*I/b)/s 
     - I*a*sign(e)*exp(-f*s*I/e)/s) 
  */
  bl( a*sign(b)/s*(I*cos(c*s/b)+sin(c*s/b))
     -a*sign(e)/s*(I*cos(f*s/e)+sin(f*s/e))),
  [bl(not iszero(b)), bl(not iszero(e))]],

 [sin(a*t + b)/(c*t + d), 
/*
  bl(  PI*cos(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s+a) 
   + I*PI*sin(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s+a) 
   -   PI*cos(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s-a)
   + I*PI*sin(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s-a) 
   - I*PI*sin(b-a*d/c)*exp(-I*s*d/c)/c
   - I*PI*sin(b-a*d/c)*exp(-I*s*d/c)/c*sign(Im(d/c))
*/
  bl( 
   +    PI/c*exp( I*(b-a*d/c))*exp(-I*s*d/c)*heaviside(s+a) 
   -    PI/c*exp(-I*(b-a*d/c))*exp(-I*s*d/c)*heaviside(s-a)
   -  I*PI/c*sin(    b-a*d/c )*exp(-I*s*d/c)
   -  I*PI/c*sin(    b-a*d/c )*exp(-I*s*d/c)*sign(Im(d/c))
  ), [bl(not iszero(c))]], 

 [cos(a*t + b)/(c*t + d), 
/*
   bl(I*PI*cos(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s+a) 
    -   PI*sin(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s+a) 
    + I*PI*cos(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s-a) 
    +   PI*sin(b-a*d/c)*exp(-I*s*d/c)/c*heaviside(s-a)
    + I*PI*cos(b-a*d/c)*exp(-I*s*d/c)/c
    - I*PI*cos(b-a*d/c)*exp(-I*s*d/c)/c*sign(Im(d/c))
   ),
*/
   bl( 
       + I*PI/c*exp( I*(b-a*d/c))*exp(-I*d/c*s)*heaviside(s+a)
       + I*PI/c*exp(-I*(b-a*d/c))*exp(-I*d/c*s)*heaviside(s-a)
       - I*PI/c*cos(    b-a*d/c )*exp(-I*d/c*s)
       - I*PI/c*cos(    b-a*d/c )*exp(-I*d/c*s)*sign(Im(d/c))
   ),
  [bl(not iszero(c))]], 
// [exp(I*a*t + b)/t, bl(I*PI*2*exp(b)*heaviside(s+a) - I*PI*exp(b)), [bl(a in R_)]], 

 [sin(a*t)^2/t, 
  bl( I*PI*heaviside(s)
    - I*PI/2*heaviside(s + 2*a) 
    - I*PI/2*heaviside(s - 2*a)  
  ), []],
 [cos(a*t)^2/t, 
  bl(
      I*PI*heaviside(s)
    - I*PI
    + I*PI/2*heaviside(s + 2*a) 
    + I*PI/2*heaviside(s - 2*a)  
  ), []],

 [abs(a*t)*exp(b*abs(c*t) + d), 
  bl(exp(d)*2*abs(a)*(b^2*abs(c)^2 - s^2) / (b^2*abs(c)^2 + s^2)^2), 
  [Re(b) <= 0]],

 [t*exp(b*abs(c*t+e) + d), 
  bl(   -exp(d)*exp(-s*I*e/c)*4*I*b*abs(c)*s/(b^2*abs(c)^2 + s^2)^2
    +e/c*exp(d)*exp(-s*I*e/c)*2  *b*abs(c)  /(b^2*abs(c)^2 + s^2)), 
  [Re(b) <= 0, bl(not iszero(c)), bl(e/c in R_)]],

 [t*exp(b*abs(c*(a*t+e)) + d), 
  bl(    -exp(d)*exp(-s*I*e/a)*4*I*b*abs(c)*s/(b^2*abs(c)^2 + s^2)^2
     +e/a*exp(d)*exp(-s*I*e/a)*2  *b*abs(c)  /(b^2*abs(c)^2 + s^2)), 
  [Re(b) <= 0, bl(not iszero(c)), bl(e in R_), bl(iszero(a+1) or iszero(a-1))]],

 //================================
 [exp(d*abs(f*t)+e)*sin(a*t+b)/(t+c), 
  bl(
     +I/2*Ei(1,+c*d*abs(f)-I*c*(s+a))*exp(e+c*d*abs(f)-I*c*(s+a)+I*b)
     +I/2*Ei(1,-c*d*abs(f)-I*c*(s-a))*exp(e-c*d*abs(f)-I*c*(s-a)-I*b)
     -I/2*Ei(1,-c*d*abs(f)-I*c*(s+a))*exp(e-c*d*abs(f)-I*c*(s+a)+I*b)
     -I/2*Ei(1,+c*d*abs(f)-I*c*(s-a))*exp(e+c*d*abs(f)-I*c*(s-a)-I*b)
    ), [Re(d) < 0, bl(not iszero(c))]],

 [exp(d*abs(f*t)+e)*cos(a*t+b)/(t+c), 
  bl(
     -1/2*Ei(1,+c*d*abs(f)-I*c*(s+a))*exp(e+c*d*abs(f)-I*c*(s+a)+I*b)
     -1/2*Ei(1,+c*d*abs(f)-I*c*(s-a))*exp(e+c*d*abs(f)-I*c*(s-a)-I*b)
     +1/2*Ei(1,-c*d*abs(f)-I*c*(s+a))*exp(e-c*d*abs(f)-I*c*(s+a)+I*b)
     +1/2*Ei(1,-c*d*abs(f)-I*c*(s-a))*exp(e-c*d*abs(f)-I*c*(s-a)-I*b)
    ), [Re(d) < 0, bl(not iszero(c))]],

 [exp(d*abs(f*t)+e)/(t+c),
  bl(
     -Ei(1,+c*d*abs(f)-I*c*s)*exp(e+c*d*abs(f)-I*c*s)
     +Ei(1,-c*d*abs(f)-I*c*s)*exp(e-c*d*abs(f)-I*c*s)
    ), [Re(d) < 0, bl(not iszero(c))]],

 //===== the limit c -> 0 =======
 [exp(d*abs(f*t)+e)*sin(a*t+b)/t, 
  bl(-arctan((s+a)/d/abs(f))*exp(e+b*I) // I/2*ln(1+(s+a)/d/abs(f)*I)*exp( b*I)
                                        //-I/2*ln(1-(s+a)/d/abs(f)*I)*exp( b*I)
     +arctan((s-a)/d/abs(f))*exp(e-b*I) // I/2*ln(1-(s-a)/d/abs(f)*I)*exp(-b*I)
                                        //-I/2*ln(1+(s-a)/d/abs(f)*I)*exp(-b*I)
    ), [Re(d) < 0]],

 [exp(d*abs(f*t)+e)*cos(a*t+b)/t, 
  bl(-I*arctan((s+a)/d/abs(f))*exp(e+b*I)
     -I*arctan((s-a)/d/abs(f))*exp(e-b*I)
    ), [Re(d) < 0]],

 [exp(d*abs(f*t)+e)/t, 
  // Alternative results are 
  // (1) -2*I*arctan(s/d/abs(f)) 
  //  = -ln(1 + I*s/d/abs(f)) + ln(1 - I*s/d/abs(f)):
  //  = ln((-d/abs(f) + s*I)/(-d/abs(f))) - ln((-d/abs(f) - s*I)(-d/abs(f)))
  // or
  // (2) ln(-d/abs(f) + s*I)- ln(-d/abs(f) - s*I).
  // These coincides with the arctan expression for 
  // abs(Im(s)) < -Re(d*abs(f)) (otherwise, the Fourier 
  // integral does not exist)
  -2*I*arctan(s/d/abs(f))*exp(e), // = ln(-d*abs(f)+s*I)*exp(e) - ln(-d*abs(f)-s*I)*exp(e)
  [Re(d) < 0] ],

 //================================
 [exp(a*t^3 + b*t + c),// The following result is valid for 
                       // imaginary a, b and real s. (Otherwise, the
                       // Fourier integral does not converge, anyway.)
  PI*2*sqrt(3)/9*((s+b/I)/a*I)^(1/2) * exp(c) * (
   -  sign((s + b/I)/a*I)^( 1/3)* besselI( 1/3, 2*sqrt(3)/9*((s + b/I)^3/a*I)^(1/2))
   +  sign((s + b/I)/a*I)^(-1/3)* besselI(-1/3, 2*sqrt(3)/9*((s + b/I)^3/a*I)^(1/2))
  ),
  [bl(iszero(Re(a))), bl(not iszero(a)), bl(iszero(Re(b)))]
 ],

 // Specialization of the pattern above to b = 0:
 [exp(a*t^3 + c),
  PI*2*sqrt(3)/9*(s/a*I)^(1/2) * exp(c) * (
   -  sign(s/a*I)^( 1/3)* besselI( 1/3, 2*sqrt(3)/9*(s^3/a*I)^(1/2))
   +  sign(s/a*I)^(-1/3)* besselI(-1/3, 2*sqrt(3)/9*(s^3/a*I)^(1/2))
  ),
  [bl(iszero(Re(a))), bl(not iszero(a))]
 ],

 // Specialization of the pattern above to c = 0:
 [exp(a*t^3),
  PI*2*sqrt(3)/9*(s/a*I)^(1/2) * (
   -  sign(s/a*I)^( 1/3)* besselI( 1/3, 2*sqrt(3)/9*(s^3/a*I)^(1/2))
   +  sign(s/a*I)^(-1/3)* besselI(-1/3, 2*sqrt(3)/9*(s^3/a*I)^(1/2))
  ),
  [bl(iszero(Re(a))), bl(not iszero(a))]
 ],

/* ---
 [exp(a*t^3 + c),  // Maple produces the following (wrong) result
   2/3*exp(c)/(a*I)^(1/3)*(-s/(a*I)^(1/3))^(1/2) * 
       besselK(1/3, -2/9*3^(1/2)*s/(a*I)^(1/3)*(-s/(a*I)^(1/3))^(1/2)), 
   [bl(not iszero(a))]],
 ],

 [exp(a*t^3 + c),  // Mathematica produces the following (wrong) result
   exp(c)*PI/9/sqrt(-a)/sqrt(-s*I)*
   (2 * abs(s) * ( 
        besselI( 1/3, 2*(I*s)^(3/2)/3/sqrt(3)/sqrt(-a))
      + besselI(-1/3, 2*(I*s)^(3/2)/3/sqrt(3)/sqrt(-a))
      )
    + I*s * (
      + besselJ( 1/3, 2*(-I*s)^(3/2)/3/sqrt(3)/sqrt(-a))
      - besselJ(-1/3, 2*(-I*s)^(3/2)/3/sqrt(3)/sqrt(-a))
      )
   );
   [bl(not iszero(a))]],
*/


 //================================
 // chebyshevT(a,x) = hypergeom([-a,a],[1/2],(1-x)/2)
 [besselJ(a, b*t + c),
  2*I^a*hypergeom([-a, a], [1/2], (1 - s/b)/2)/(b^2-s^2)^(1/2) *
  exp(-I*s*c/b)*
    (heaviside(s + abs(b))-heaviside(s - abs(b))),
  [bl(iszero(Im(b))), bl(not iszero(b))]
 ],

 // chebyshevU(n,x) = (n+1)*hypergeom([-n,n+2],[3/2],(1-x)/2)
 [besselJ(a, b*t)/t,
  2*I^(a-1)*hypergeom([1-a, 1+a], [3/2], (1 - s/b)/2)*(b^2-s^2)^(1/2)/b *
    (heaviside(s + abs(b))-heaviside(s - abs(b))),
  [bl(iszero(Im(b))), bl(not iszero(b))]
 ],

 //================================
 [abs(a*t+b), -2*exp(-I*s*b/a)*abs(a)/s^2],

 [abs(a*t+b)*heaviside(c*t+d), 

  -abs(a)*sign(c)*I*PI*dirac(s, 1)*exp(-I*s*b/a)
  -abs(a)/s^2*exp(-I*s*b/a)
  -abs(a)*sign(d-b*c/a)/s^2*exp(-I*s*b/a)
  +abs(a)*sign(d-b*c/a)/s^2*exp(-I*s*d/c)
  +abs(a)*sign(d-b*c/a)*(d/c-b/a)*I/s*exp(-I*s*d/c)
  ,
  [] // we need d and c to be real, but do not state the 
     // assumptions 'd in R_' etc. here (the user would 
     // need to state them, too, to make this pattern 
     // work). Assume it implicitly!
 ],
 null()
]:
