// Dirk Mueller, olorien, 28/10/96, v1.0 

// References: 
//		H. Heuser : Gewhnliche Differentialgleichungen, Teubner, 1989
//		F. Oberhettinger, L. Badi : Tables of Laplace Transforms, Springer, 1973		

alias( IntTrans = transform::IntTrans ):

_mult::"transform::invlaplace":=
  proc(_fu, var1, var2) 
    local Num, Den, Num_L, Den_L, Num_code, Den_code, exps,
          Num_nmb, Den_nmb, Den_sp, erg, _lin,
          Num_sp, Num_match, Den_match, Num_pat,
          Den_code_rat, Den_code_nonrat, Den_pat_nonrat,
          _a, _b, _c, _d,  _e, _f, _w, _n, _i, i,
          _A, _B, _C, _D, _p1, _p2,
          _b2, _d2, _w2, _a_times_b, _a_plus_b, _a_minus_b,
	 _bol;
  begin

    Num:=numer(_fu); 

    if type(Num)="_mult" then
      _lin:=select(Num, not has, var1);
      Num:=Num/_lin;
    elif not has(Num, var1) then
      _lin:=Num; Num:=1;
    else
      _lin:=1;
    end_if;

    Den:=denom(_fu); 
    if type(Den) = "exp" then
      [Num, Den]:= [Num/Den, 1];
    elif type(Den)="_mult" then
      // move exponentials from the denominator to the numerator
      [exps, Den]:= split(Den, testtype, "exp")[1..2];
      Num:= Num/exps;
    end_if;

    Num_sp:=IntTrans::mult_split(Num, var1);
    Den_sp:=IntTrans::mult_split(Den, var1);

    if Num_sp[2]=1 and Den_sp[2]=1 then // Rat / Rat 
      Den_L:=IntTrans::anapol(Den, var1);
      Num_L:=IntTrans::anapol(Num, var1);
      Den_code:={op(Den_L[1])}; Den_nmb:=nops(Den_L[1]);
      Num_code:={op(Num_L[1])}; Num_nmb:=nops(Num_L[1]);

      case [Den_code, Den_nmb]
      of [{[2,3]}, 1] do // (...)/(a*s+b)^2 
        if Num_L[1]=[[1,2]] then // s/(a*s+b)^2 
          _b:=Den_L[2][1][1]; _a:=Den_L[2][1][2];
          userinfo(10, "formula 10 from Heuser");
          return( _lin*(1-_b/_a*var2)*exp(-_b/_a*var2)/_a^2 );
        end_if;
        break;

      of [{[1,3]}, 2] do // (...)/(a*s+b)/(c*s+d) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/(a*s+b)/(c*s+d) 
          _a:=Den_L[2][1][2]; _b:=Den_L[2][1][1];
          _c:=Den_L[2][2][2]; _d:=Den_L[2][2][1];
          userinfo(10, "formula 6 from Heuser"); 
          return( _lin*(exp(-_d/_c*var2)-exp(-_b/_a*var2))/(_c*_b-_a*_d) );

        of [{[1,2]}, 1] do // s/(a*s+b)/(c*s+d) 
          _a:=Den_L[2][1][2]; _b:=Den_L[2][1][1];
          _c:=Den_L[2][2][2]; _d:=Den_L[2][2][1];

          userinfo(10, "formula 11 from Heuser"); 
          return( _lin*(_b/_a*exp(-_b/_a*var2)-_d/_c*
                        exp(-_d/_c*var2))/(_b*_c-_d*_a));

        of [{[1,3]}, 1] do // (A*s+B)/(a*s+b)/(c*s+d) 
          _A:=Num_L[2][1][2]; _B:=Num_L[2][1][1];
          _a:=Den_L[2][1][2]; _b:=Den_L[2][1][1];
          _c:=Den_L[2][2][2]; _d:=Den_L[2][2][1];
          userinfo(10, "formula 12 from Heuser");
          return(  _lin*((_b/_a*_A-_B)*exp(-_b/_a*var2)
                   -(_d/_c*_A-_B)*exp(-_d/_c*var2))
                   /(_b*_c-_d*_a)  );
        end_case; // [Num_code, Num_nmb] 
        break;

      of [{[1,3]}, 3] do // (...)/(a*s+b)/(c*s+d)/(e*s+f) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/(a*s+b)/(c*s+d)/(e*s+f) 
          _a:=Den_L[2][1][2]; _b:=Den_L[2][1][1]/_a;
          _c:=Den_L[2][2][2]; _d:=Den_L[2][2][1]/_c;
          _e:=Den_L[2][3][2]; _f:=Den_L[2][3][1]/_e;
          userinfo(10, "formula 24 from Heuser"); 
          return(  _lin*(exp(-_b*var2)/(_d-_b)/(_f-_b)
                  +exp(-_d*var2)/(_b-_d)/(_f-_d)
                  +exp(-_f*var2)/(_b-_f)/(_d-_f))/_a/_c/_e );

        of [{[1,2]}, 1] do // s/(a*s+b)/(c*s+d)/(e*s+f) 
          _a:=Den_L[2][1][2]; _b:=Den_L[2][1][1]/_a;
          _c:=Den_L[2][2][2]; _d:=Den_L[2][2][1]/_c;
          _e:=Den_L[2][3][2]; _f:=Den_L[2][3][1]/_e;
          userinfo(10, "formula 25 from Heuser"); 
          return(  _lin*(-_b*exp(-_b*var2)/(_d-_b)/(_f-_b)
                  -_d*exp(-_d*var2)/(_b-_d)/(_f-_d)
                  -_f*exp(-_f*var2)/(_b-_f)/(_d-_f))/_a/_c/_e );

        of [{[2,2]}, 1] do // s^2/(a*s+b)/(c*s+d)/(e*s+f) 
          _a:=Den_L[2][1][2]; _b:=Den_L[2][1][1]/_a;
          _c:=Den_L[2][2][2]; _d:=Den_L[2][2][1]/_c;
          _e:=Den_L[2][3][2]; _f:=Den_L[2][3][1]/_e;
          userinfo(10, "formula 26 from Heuser"); 
          return(  _lin*(_b^2*exp(-_b*var2)/(_d-_b)/(_f-_b)
                  +_d^2*exp(-_d*var2)/(_b-_d)/(_f-_d)
                  +_f^2*exp(-_f*var2)/(_b-_f)/(_d-_f))/_a/_c/_e );

        end_case; // [Num_code, Num_nmb] 
        break; // [{[1,3]}, 3] 

      of [{[1,5]}, 1] do // (...)/(a*s^2+b) 
        if Num_L[1]=[[1,2]] then // s/(a*s^2+b) 
          _a:=Den_L[2][1][3]; _b:=Den_L[2][1][1];
          _b:=_b/_a;
          if IntTrans::Minus(_b) then
            userinfo(10, "formula 14 from Heuser");
            return( _lin*cosh(specfunc::Wurzelbehandlung(-_b)*var2)/_a  );
          end_if;
          userinfo(10, "formula 13 from Heuser");
          return( _lin*cos(specfunc::Wurzelbehandlung(_b)*var2)/_a  );
        end_if;
        break;
 
      of [{[1,5]}, 2] do // (...)/(a*s^2+b)/(c*s^2+d) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/(a*s^2+b)/(c*s^2+d) 
          _a:=Den_L[2][1][3];
          _b2:=Den_L[2][1][1]; _b:=specfunc::Wurzelbehandlung(_b2);
          _c:=Den_L[2][2][3];
          _d2:=Den_L[2][2][1]; _d:=specfunc::Wurzelbehandlung(_d2);
          _A:=_b/specfunc::Wurzelbehandlung(_a); _B:=_d/specfunc::Wurzelbehandlung(_c);
          
          userinfo(10, "formula 33 from Heuser");
          return( _lin*( (_A*sin(_B*var2)-_B*sin(_A*var2))
                    /_A/_B/(_A^2-_B^2)   )/_a/_c );

        of [{[1,2]}, 1] do // s/(a*s^2+b)/(c*s^2+d) 
          _a:=Den_L[2][1][3]; _b:=Den_L[2][1][1]; _A:=specfunc::Wurzelbehandlung(_b/_a); 
          _c:=Den_L[2][2][3]; _d:=Den_L[2][2][1]; _B:=specfunc::Wurzelbehandlung(_d/_c);
          userinfo(10, "formula 37 from Heuser");
          return( _lin*(cos(_B*var2)-cos(_A*var2))/(_b*_c-_a*_d) );
        end_case;
        break;

	// S.H. 11/2002: closely related are the following 
      of [{[2,2], [1,7]}, 2] do // (...)/s^2/(c*s^2+d*s + e) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/s^2/(c*s^2+d*s + e) 

          _c:=Den_L[2][2][3];
          _d:=Den_L[2][2][2]; 
          _e:=Den_L[2][2][1];
	  if not iszero(_c) then
		_A:=solve(var1^2+_d/_c*var1+_e/_c, var1);
		_bol := FALSE;
	  	if nops(_A) = 1 then
			_a := op(_A,1);
			_b := _a;
			_bol := TRUE;
		elif nops(_A) = 2 then
			_a := op(_A,1);
			_b := op(_A,2);
			_bol := TRUE;
		end_if;	
	  	if _bol and (type(_a) = "_mult" or type(_b) = "_mult") then
				// hopefully this way is easier
			_lin := _lin/_c;
			_a_times_b := _a*_b;
			_a_plus_b  := _a+_b;
			_a_minus_b := _a-_b;	//
			if _a_times_b <> 0 and _a_minus_b <> 0 then
		          userinfo(10, "formula 2.18 from Oberhettinger");
        		  return( _lin*(var2/_a_times_b + _a_plus_b/_a_times_b^2
				- 1/(_a_minus_b)*(exp(_b*var2)/_b^2 - exp(_a*var2)/_a^2))
	                   	);
			end_if;
		else // we better to do it by hand
			_lin := _lin/_c;
			_b2 := -_d/(2*_c);
			_d2 := specfunc::Wurzelbehandlung(_d^2 - 4*_c*_e)/(2*_c);
                // bug fix (Walter 22.7.05)
                // The following 2 lines were: _a := -b2 + _d2; _b := -b2 - d_2
			_a := _b2 + _d2;
			_b := _b2 - _d2;
                        _a_times_b := _e/_c;
                        _a_plus_b  := - _d/_c;
                        _a_minus_b := 2*_d2;	// + or - is irrelevant in solution
			if _d <> 0 then
		          userinfo(10, "formula 2.18 from Oberhettinger");
        		  return( _lin*(var2/_a_times_b + _a_plus_b/_a_times_b^2
				- 1/(_a_minus_b)*(exp(_b*var2)/_b^2 - exp(_a*var2)/_a^2))
	                   	);	
			end_if;
		end_if;
	 end_if;
	end_case;
        break;
	// and:
      of [{[2,2], [1,3]}, 3] do // (...)/s^2/(a*s+b)/(c*s + d) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/s^2/(A*s+a*A)/(B*s + b*B) 
          _A:=Den_L[2][2][2];
          _c:=Den_L[2][2][1]; 
          _B:=Den_L[2][3][2];
          _d:=Den_L[2][3][1];
	  if not iszero(_A*_B) then
		_a := -_c/_A;	// the two zeros
		_b := -_d/_B;	// of (A*s+a*A)/(B*s + b*B)
		_a_times_b := _c*_d;		// not quite literally
		_a_plus_b  := _c*_B+_d*_A;   	// not quite literally
		_a_minus_b := _c*_B-_d*_A;	// again not quite literally
		  if _a_times_b <> 0 and _a_minus_b <> 0 then
		          userinfo(10, "formula 2.18 from Oberhettinger");
	        	  return( _lin*(var2/_a_times_b - _a_plus_b/_a_times_b^2
				+ 1/(_a_minus_b)*(exp(_b*var2)/_b^2 - exp(_a*var2)/_a^2))
        	           	);
		  end_if;
	  end_if;
	end_case;
        break;

      of [{[2,5]}, 1] do // (...)/(a*s^2+b)^2 
        case [Num_code, Num_nmb]
        of [{[1,2]}, 1] do // s/(a*s^2+b)^2 
          _a:=Den_L[2][1][3]; _b:=Den_L[2][1][1];
          if IntTrans::Minus(_b/_a) then
            _w:=specfunc::Wurzelbehandlung(-_b/_a);
            userinfo(10, "formula 35 from Heuser");
            return( _lin*( var2*sinh(_w*var2))/_w/2/_a^2  );
          end_if;
          _w:=specfunc::Wurzelbehandlung(_b/_a);
          userinfo(10, "formula 34 from Heuser");
          return( _lin*( var2*sin(_w*var2))/_w/2/_a^2 );

        of [{[2,2]}, 1] do // s^2/(a*s^2+b)^2 
          _a:=Den_L[2][1][3]; _b:=Den_L[2][1][1];
          if IntTrans::Minus(_b/_a) then
            _w:=specfunc::Wurzelbehandlung(-_b/_a);
            userinfo(10, "formula 40 from Heuser");
            return( _lin*( sinh(_w*var2)+_w*var2*cosh(_w*var2))/2/_w/_a^2);
          end_if;
          _w:=specfunc::Wurzelbehandlung(_b/_a);
          userinfo(10, "formula 39 from Heuser");
          return( _lin*(sin(_w*var2)+_w*var2*cos(_w*var2))/2/_w/_a^2  );
  
        of [{[3,2]}, 1] do // s^3/(a*s^2+b)^2 
          _a:=Den_L[2][1][3]; _b:=Den_L[2][1][1]; 
          if IntTrans::Minus(_b/_a) then
            _w:=specfunc::Wurzelbehandlung(-_b/_a);
            userinfo(10, "formula 43 from Heuser");
            return( _lin*( cosh(_w*var2)+1/2*_w*var2*sinh(_w*var2) )/_a^2);
          end_if;
          userinfo(10, "formula 42 from Heuser");
          _w:=specfunc::Wurzelbehandlung(_b/_a);
          return( _lin*( cos(_w*var2)-1/2*_w*var2*sin(_w*var2) )/_a^2  );
 
        of [{[1,5]}, 1] do // (A*s^2+B)/(a*s^2+b)^2 
          _a:=Den_L[2][1][3];
          _b:=-Den_L[2][1][1]; 
          _A:=Num_L[2][1][3]; _B:=Num_L[2][1][1];
          _w:=specfunc::Wurzelbehandlung(_b/_a);
          if is(_B=_b)=TRUE then
            userinfo(10, "formula 41 from Heuser");
            return( _lin*( var2*cosh(_w*var2) )*_A/_a^2 );
          end_if;
          break;
        end_case; // [Num_code, Num_nmb] 
        break;

      of [{[1,7]}, 1] do     // denominator is quadratic
        case [Num_code, Num_nmb]
        of [{[1,2]}, 1] do   // numerator is linear, no constant term
        of [{[1,3]}, 1] do   // numerator is linear with constant term


	// ------------------------------------------------
	// changes by Stephan Huckeman Feb. 20. 2002
	//   A (s + B)/(s^2 + 2 b s + c) where A <> 0

          _a:=Den_L[2][1][3];  // a <> 0
          _b:=Den_L[2][1][2]/(2* _a); 
          _c:=Den_L[2][1][1]/_a;
          _A:=Num_L[2][1][2]/_a; 
          _B:=Num_L[2][1][1]/(_A * _a);
	  _D:=_B - _b;
	  _d:= _c - _b^2;		// discriminator

	// A (s + b + D) / ((s + b)^2 + d)
	// coordinate shift s + b -> s results in multiplying by exp(-tb)
	  if iszero(_d) then
	     // A (s + D)/s^2 = A ( 1/s + D/s^2) -> A (1 + D t)
		return(_lin*exp(-_b*var2)*_A*(1 + _D*var2));
	  end_if;	   
	  if is(_d > 0)=TRUE then
	     // A (s + D)/(s^2 + e^2) = A (s /(s^2 + e^2) + (D/e) e/(s^2 + e^2))
	     // -> A (cos(et) + D/e sin(et))
		_e := specfunc::Wurzelbehandlung(_d);
                return(_lin*exp(-_b*var2)*_A*(cos(_e*var2)+_D/_e*sin(_e*var2)));
	  end_if; 
	  // if is(_d < 0)=TRUE then
	     // A (s + D)/(s^2 - e^2) = A (s /(s^2 - e^2) + D/(s^2 - e^2))
	     // -> A (cosh(et) + D/e sinh(et))
		_e := specfunc::Wurzelbehandlung(-_d);
                return(_lin*exp(-_b*var2)*_A*(cosh(_e*var2)+_D/_e*sinh(_e*var2)));
	  // end_if;

        // ------------------------------------------------

/*
          _a2:=Den_L[2][1][3]; _a:=specfunc::Wurzelbehandlung(_a2);
          _b:=Den_L[2][1][2]/2/_a; 
          _c:=Den_L[2][1][1]-_b^2;
          _A:=Num_L[2][1][2]; _B:=Num_L[2][1][1];

          if is(_B/_A=_b/_a)=TRUE then
            if IntTrans::Minus(_c) then
              _w:=specfunc::Wurzelbehandlung(-_c/_a2);
              userinfo(10, "formula 16 from Heuser");
              return(_lin*(exp(-_B/_A*var2)*cosh(_w*var2)*_A/_a2) );
            else
              _w:=specfunc::Wurzelbehandlung(_c/_a2);
              userinfo(10, "formula 15 from Heuser");
              return( _lin*(exp(-_B/_A*var2)*cos(_w*var2)*_A/_a2) );
            end_if;
          else

            _a:=Den_L[2][1][3]; _b:=Den_L[2][1][2]; _b2:=_b^2;
            _c:=Den_L[2][1][1]; _c2:=_c^2;
            _A:=Num_L[2][1][2]; _B:=Num_L[2][1][1];
            _r:=_b/_a/2; _w:=specfunc::Wurzelbehandlung(_c/_a-_r^2 );

            if is(_c/_a>_r^2)=TRUE then
      
              userinfo(10, "fromula 17 from Heuser");
              return( _lin*( exp(-_r*var2)* 
                         ( _A*cos(_w*var2)+(_B-_r*_A)/_w*sin(_w*var2)  )/_a)
                          );
            end_if;

            if is(_c/_a<_r^2)=TRUE then
              _w:=specfunc::Wurzelbehandlung(_b2-_c2);
              if _w <> 0 then
                // what if _w = 0 ?? Stefan
                userinfo(10, "fromula 17 from Heuser (modified)");
                return( _lin*( exp(-_r*var2)*
                              (_A*cosh(_w*var2)
                               +(_B-_r*_A)/_w/I*
                               sinh(_w*var2)  )
                              /_a)
                          );
              end_if
            end_if;
          end_if;
*/
        end_case;
        break;

      of [{[1,17]}, 1] do // (...)/(a*s^4+b) 
        case [Num_code, Num_nmb]
        of [{[1,2]}, 1] do // s/(a*s^4+b) 
          _a:=Den_L[2][1][5]; _b:=Den_L[2][1][1]; 
          if stdlib::hasmsign(_b/_a) then
            // _w:=(-_b/_a)^(1/4); 
            _w:= specfunc::Wurzelbehandlung(specfunc::Wurzelbehandlung(-_b/_a)):
            userinfo(10, "formula 36 from Heuser");
            return( _lin*( cosh(_w*var2)-cos(_w*var2) )/2/_a/_w^2  );
          end_if;
          userinfo(10, "formula 38 from Heuser");
          // _w:=(_b/_a/4)^(1/4);
          _w:= specfunc::Wurzelbehandlung(specfunc::Wurzelbehandlung((_b/_a/4))):
          return( _lin*( sin(_w*var2)*sinh(_w*var2) )/2/_a/_w^2 );
        end_case;
        break;

      of [{[1,2], [1,3]}, 2] do // (...)/s/(a*s+b) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/s/(a*s+b) 
          _p1:=contains(Den_L[1], [1,3]); 
          _a:=Den_L[2][_p1][2];
          _b:=Den_L[2][_p1][1];
          userinfo(10, "formula 5 from Heuser");
          return( _lin*(1-exp(-_b/_a*var2))/_b  );

        of [{[1,3]}, 1] do // (A*s+B)/s/(a*s+b)
          _p1:=contains(Den_L[1], [1,3]); 
          _a:=Den_L[2][_p1][2];
          _b:=Den_L[2][_p1][1];
          _A:=Num_L[2][1][2]; _B:=Num_L[2][1][1];
          userinfo(10, "(A*s+B)/s/(a*s+b)");
          return(_lin*(_B/_b + (_A*_b - _B*_a)/(_a*_b*exp((_b*var2)/_a))));

        end_case; // [Num_code, Num_nmb] 
        break;
 
      of [{[1,2], [1,3]}, 3] do // (...)/s/(a*s+b)/(c*s+d) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/s/(a*s+b)/(c*s+c) 
          _p1:=contains(Den_L[1], [1,3]);
          _p2:=contains(Den_L[1], [1,3], _p1+1);
          _a:=Den_L[2][_p1][2]; _b:=Den_L[2][_p1][1]/_a;
          _c:=Den_L[2][_p2][2]; _d:=Den_L[2][_p2][1]/_c;
          userinfo(10, "formula 1.4 from R&K");
          return( _lin*(1/_b/_d+(_d*exp(-_b*var2)-_b*exp(-_d*var2))
                    /_b/_d/(_b-_d))/_a/_c  );

        of [{[1,3]}, 1] do // (A*s+B)/s/(a*s+b)/(c*s+d) 
          _p1:=contains(Den_L[1], [1,3]);
          _p2:=contains(Den_L[1], [1,3], _p1+1);
          _a:=Den_L[2][_p1][2]; _b:=Den_L[2][_p1][1]/_a;
          _c:=Den_L[2][_p2][2]; _d:=Den_L[2][_p2][1]/_c;
          _A:=Num_L[2][1][2]; _B:=Num_L[2][1][1]/_A;
          userinfo(10, "formula 1.5 from R&K");
          return( _lin*(_B/_b/_d
                        +(_d*(_B-_b)*exp(-_b*var2)
                         -_b*(_B-_d)*exp(-_d*var2)
                         )/_b/_d/(_b-_d)
                       )*_A/_a/_c );

        of [{[1,7]}, 1] do // (A*s^2+B*s+C)/s/(a*s+b)/(c*s+c) 
          _p1:=contains(Den_L[1], [1,3]);
          _p2:=contains(Den_L[1], [1,3], _p1+1);
          _a:=Den_L[2][_p1][2]; _b:=Den_L[2][_p1][1]/_a;
          _c:=Den_L[2][_p2][2]; _d:=Den_L[2][_p2][1]/_c;
          _A:=Num_L[2][1][3]; _B:=Num_L[2][1][2]/_A; _C:=Num_L[2][1][1]/_A;
          userinfo(10, "formula 1.6 from R&K");
          return( _lin*(_C/_b/_d
                       +( _d*(_b^2-_B*_b+_C)*exp(-_b*var2)
                         -_b*(_d^2-_B*_d+_C)*exp(-_d*var2)
                        )/_b/_d/(_b-_d))*_A/_a/_c );
        end_case; // [Num_code, Num_nmb] 

      of [{[1,2], [1,5]}, 2] do // (...)/(s*(a*s^2+b)) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/(s*(a*s^2+b)) 
          _p1:=contains(Den_L[1], [1,5]); 
          _a:=Den_L[2][_p1][3];
          _b:=Den_L[2][_p1][1]; _w:=_b/_a;
          if IntTrans::Minus(_w) then
            userinfo(10, "formula 21 from Heuser");
            return( -_lin*(cosh(specfunc::Wurzelbehandlung(-_w)*var2)/_b-1/_b)  );
          end_if;
          userinfo(10, "formula 20 from Heuser");
          return( _lin*(1/_b-cos(specfunc::Wurzelbehandlung(_w)*var2)/_b)  );

        of [{[1,5]}, 1] do // (A*s^2+B)/s/(a*s^2+b) 
          _p1:=contains(Den_L[1], [1,5]);
          _A:=Num_L[2][1][3]; _B:=Num_L[2][1][1];       
          _a:=Den_L[2][_p1][3]; _b:=Den_L[2][_p1][1];

          if is(_B/_A=_b/_a/2)=TRUE then
            userinfo(10, "formula 27 from Heuser");
            return( _lin*( cos( specfunc::Wurzelbehandlung(_B/2/_A)*var2))^2/_a*_A );
          end_if;

        end_case; // [Num_code, Num_nmb] 
        break;

      of [{[1,2], [1,7]}, 2] do // (...)/s/(a*s^2+b*s+c) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/s*/(a*s^2+b*s+c) 
          _p1:=contains(Den_L[1], [1,7]); 
          _a:=Den_L[2][_p1][3];
          _b:=Den_L[2][_p1][2];
          _c:=Den_L[2][_p1][1]; 
          _w:=normal(_c/_a-(_b/_a/2)^2);
          erg:=is(_w>0);
          if erg=TRUE then
            _w:=specfunc::Wurzelbehandlung(_w);
            userinfo(10, "formula 23 from Heuser, case 1");
            return( _lin*(1/_c-exp(-_b/_a/2*var2)/_w/_c*
                       (_b/_a/2*sin(_w*var2)+_w*cos(_w*var2))));
          end_if;

          erg:=is(_w<0);
          if erg=TRUE then
            _w:= specfunc::Wurzelbehandlung(-_w);
            userinfo(10, "formula 23 from Heuser, case 2");
            return( _lin*(1/_c-exp(-_b/_a/2*var2)/_w/_c*(_b/_a/2
                        *sinh(_w*var2)+_w*cosh(_w*var2))));
          end_if;

          erg:=is(_w=0);
          if erg=TRUE then
            userinfo(10, "formula 23 from Heuser, case 3");
            return( _lin*(1/_c-1/_c*exp(-_b/_a/2*var2)-
                       _b/_a/_c/2*var2*exp(-_b/_a/2*var2)));
          end_if;
          return(FAIL);

        end_case; // [Num_code, Num_nmb] 
        break;

      of [{[2,2], [1,5]}, 2] do // (...)/s^2/(a*s^2+b) 
        case [Num_code, Num_nmb]
        of [{[1,1]}, 1] do // 1/s^2/(a*s^2+b) 
          _p1:=contains(Den_L[1], [1,5]);
          _a:=Den_L[2][_p1][3]; _b:=Den_L[2][_p1][1];
          _w2:=_b/_a; _w:=specfunc::Wurzelbehandlung(_w2);
          userinfo(10, "formula 29 from Heuser");
          return(_lin*(var2/_b-sin(_w*var2)/_b/_w));
        end_case;  // [Num_code, Num_nmb] 
        break;
      end_case; // [Den_code, Den_nmb] 

      return(FAIL);
   
    elif [Den_sp]=[1,1] then // Nonrat / 1 
      return(FAIL);

    elif Num_sp[1]=1 and Den_sp[1]=1 then // Nonrat / Nonrat 

      if type(Num)<>"_mult" then
        Num_match:={type(Num)}, 1;
        Num_nmb:=1;
      else
        Num_L:=IntTrans::anatype(Num);
        // Walter, 6.3.01: Die Reihenfolge der folgenden beiden
        // Befehle ausgetauscht (sonst Num_nmb nicht initialisiert).
        // Keine Idee, ob das ok ist.
        Num_nmb:=nops(Num_L);
        Num_match:={op(Num_L)}, Num_nmb;
      end_if;

      if type(Den)<>"_mult" then
        Den_match:={type(Den)}, 1;
        Den_nmb:=1;
      else
        Den_L:=IntTrans::anatype(Den);
        Den_nmb:=nops(Den_L);
        Den_match:={op(Den_L)}, Den_nmb;
// ------------- S.H. Nov. 2003 ------moved this line one line upstairs ---
        // Den_nmb:=nops(Den_L); 
      end_if;

      case  [Num_match, Den_match]
      of [ {"ln"}, 1, {"_power"}, 1] do
        if op(Den, 1)=var1 then
          if is(op(Den, 2)>0)=TRUE then
            _n:=op(Den, 2)-1;
            _i:=genident();
            return(_lin*(hold(sum)(1/_i, _i=1.._n)
                        -ln(var2)-EULER)*var2^_n/fact(_n));
          end_if;
        end_if;
      end_case:

      return(FAIL);

    elif Num_sp[2]=1 and Den_sp[1]=1 then // Rat / NonRat 

    /* Walter 18.12.06: no idea, what should be returned here
      Num_L:=IntTrans::anapol(Num, var1);
      Num_code:={op(Num_L[1])}; Num_nmb:=nops(Num_L[1]);
      Den_code:=IntTrans::nonrat_ana(Den, var1);
    */
      return(FAIL);

    elif Num_sp[1]=1 and Den_sp[2]=1 then // NonRat / Rat 
      Den_L:=IntTrans::anapol(Den, var1);
      Den_code:={op(Den_L[1])}; Den_nmb:=nops(Den_L[1]);
      Num_code:=IntTrans::nonrat_ana(Num, var1);
      if Num_code = FAIL then
         return(FAIL)
      end_if;

      Num_pat:=[Num_code[1], Num_code[2], Num_code[3]];

      case Den_code
      of {[1/2, 2]} do

        case Num_pat

        of ["_mult", ["exp"], [1]] do
          _a:=Num_code[4][1]*var1;
	  // if not has(_a,s) then 
          if not has(_a,var1) then
            if IntTrans::Minus(_a) then // lin*exp(a/s)/sqrt(s)
              userinfo(10, "formula 55 from Heuser");
              return( _lin*(1/sqrt(PI*var2)*cos(2*specfunc::Wurzelbehandlung(-_a*var2))) );
            else                       // lin*exp(a/s)/sqrt(s)
              userinfo(10, "formula 56 from Heuser");
              return( _lin*( 1/sqrt(PI*var2)*cosh(2*specfunc::Wurzelbehandlung(_a*var2))) );
            end_if;
          end_if;

          _a:=op(Num)/sqrt(var1);
          // if not has(_a,s) then 
	  if not has(_a,var1) then
            if is(_a<=0)=TRUE then     // lin*exp(a*sqrt(s))/sqrt(s)
              userinfo(10, "formula 58 from Heuser");
              return( _lin*(1/sqrt(PI*var2)*exp(-_a^2/4/var2)) );
            end_if;
            return(FAIL);
          end_if;
        end_case; // [Num_pat] 
        break;

      of {[1,2]} do // [Den_code] // case ln(s^b)/s
        case Num_pat
        of ["_mult", ["ln"], [1]] do
          if Num_code[4][1]=var1 then
            userinfo(10, "formula 60 from Heuser");
            return(_lin*(-ln(var2)-EULER));
	  elif	// extended functionality by Stephan H. May 6, 2003
	     type(Num_code[4][1])="_power" then
		if op(Num_code[4][1])[1] = var1 then
			_a := op(Num_code[4][1])[2];
	                return(_lin*_a*(-ln(var2)-EULER));		
		end_if;
          end_if;
          break;
        end_case; // [Num_pat] 
        break;

      of {[1,5]} do // [Den_code] 

        case Num_pat
        of ["_mult", ["exp"], [1]] do  // exp(c*s)/(a*s^2 + b)
          _c:=Num_code[4][1]/var1; 
          _a:=Den_L[2][1][3]; 
          _b:=Den_L[2][1][1];
          userinfo(10, "formula from M&P");
          _w:=specfunc::Wurzelbehandlung(_b/_a);
          return( heaviside(var2+_c)*sin( _w*(var2+_c))/_w/_a);
        end_case: // Num_pat 
      end_case: // Den_code 

      if Den_nmb=1 then 
        case Den_L[1][1][2]
        of 2 do
          case Num_pat
          of ["_mult", ["ln"], [1]]  do
            _n:=Den_L[3][1][1];
            if testtype(_n, Type::PosInt) then
			  // bug-fix Stephan H. May 6, 2003
		          if Num_code[4][1]=var1 then
              userinfo(10, "formula 61 from Heuser");
              return( _lin*((_plus( 1/i $ i=1.._n-1 )
                        -ln(var2)-EULER)*var2^(_n-1)/fact(_n-1)));
	  		   elif	// extended functionality by Stephan H. May 6, 2003
	     type(Num_code[4][1])="_power" then
		if op(Num_code[4][1])[1] = var1 then
			_a := op(Num_code[4][1])[2];
              return( _lin*_a*((_plus( 1/i $ i=1.._n-1 )
                        -ln(var2)-EULER)*var2^(_n-1)/fact(_n-1)));	      
		end_if;
			  end_if;
            end_if;
          end_case;
        end_case;
      end_if;

    elif Num_sp[2]=1 and Num_sp[1]<>1 and
         Den_sp[1]<>1 and Den_sp[2]<>1 then // RAT / (Nonrat * Rat) 
      Num_L:=IntTrans::anapol(Num, var1);

      Num_code:={op(Num_L[1])}; Num_nmb:=nops(Num_L[1]);

      Den_code_rat:=IntTrans::anapol(Den_sp[1], var1);
      Den_code_nonrat:=IntTrans::nonrat_ana(Den_sp[2], var1);
      if Den_code_nonrat = FAIL then
         return(FAIL);
      end_if;
      Den_pat_nonrat:=[Den_code_nonrat[1], Den_code_nonrat[2], Den_code_nonrat[3]];

      case Num_code
      of {[1, 2]} do
        case Den_pat_nonrat
        of ["_mult", ["exp"], [1]] do
          case {Den_code_rat[1][1]}
          of {[1,5]} do                       // exp(-c*x)*s/(s^2*a + b)
            _c:=Den_code_nonrat[4][1]/var1;
            if not has(_c, var1) then
              _a:=Den_code_rat[2][1][3];
              _b:=Den_code_rat[2][1][1];
              return( heaviside(var2-_c)*cos(specfunc::Wurzelbehandlung(_b/_a)*(var2-_c))/_a);
            end_if;
          end_case:
        end_case:
      end_case:
 
    elif Num=1 and
         Den_sp[1]<>1 and Den_sp[2]<>1 then // 1 / (Nonrat * Rat) 

      Den_code_rat:=IntTrans::anapol(Den_sp[1], var1);
      Den_code_nonrat:=IntTrans::nonrat_ana(Den_sp[2], var1);
      if Den_code_nonrat = FAIL then
         return(FAIL)
      end_if;
      Den_pat_nonrat:=[Den_code_nonrat[1], Den_code_nonrat[2],
                             Den_code_nonrat[3]];
      case Den_pat_nonrat
      of ["_mult", ["exp"], [1]] do
        case {Den_code_rat[1][1]}
        of {[1,5]} do
          _c:=Den_code_nonrat[4][1]/var1;
          if not has(_c, var1) then
            _a:=Den_code_rat[2][1][3];
            _b:=Den_code_rat[2][1][1];
            userinfo(10, "formula from M&P");
	    /* PZ: changed 'cos' to 'sin' because it gave
		a wrong result for invlaplace(1/exp(s)^2/(s^2+1),s,t) */
            return(  heaviside(var2-_c)
                   * sin(sqrt(_b/_a)*(var2-_c))
                   / sqrt(_a*_b)  );
          end_if;
        end_case:
      end_case:

    else // Num_sp[2]=? and Den_sp[2]=?, mixed 
      return(FAIL);
    end_if; // Num_sp[2]=? and Den_sp[2]=? 
    return(FAIL);
  end_proc:

unalias( IntTrans ):

// end of file 

