// laplace(Si(a*t), t, s) = arctan(a/s)/s)

Si::"transform::laplace":=
  proc(f, t, s) 
    local g, a, b;
  begin
    // f = Si(g(t)); g = g(t)
    g:= expand(op(f));
    // only g = a*t + b can be treated:
    a:= diff(g, t);
    if has(a, t) then
       return(FAIL);
    end_if;
    // In fact, only b = 0 can be treated:
    b:= subs(g, t = 0, EvalChanges);
    if not iszero(b) then
       return(FAIL);
    end_if;
    return(arctan(a/s)/s);
    FAIL;
  end_proc:

// end of file 
