besselJ::"transform::laplace":=
  proc(_f, var1, var2) 
    local a, b, bt;
  begin
   //  cf. "Laplace Transforms by Oberhettinger, 14.1
   // ==============================================================================
   // laplace(besselJ(c, d*t),t,s) = d^(c)*(d^2+s^2)^(-1/2)*((d^2+s^2)^(1/2)+s)^(-c)
   // ==============================================================================
   a:=op(_f,1); 
   bt:=op(_f,2);
   if is(Re(a) > -1)= TRUE then
      b:=bt/var1;
      if (not has([a, b], var1)) then
        return(b^a/(sqrt(var2^2+b^2)+var2 )^a/sqrt(var2^2+b^2));
      end_if;
   end_if;
   // ===================================================================
   // laplace(besselJ(a, b*sqrt(x)), x, y) = 
   //   b/4*sqrt(PI)/s^(3/2)*exp(-b^2/8/s)* (BesselI(a/2 - 1/2, b^2/8/s) 
   //                                       -BesselI(a/2 + 1/2, b^2/8/s))
   // ===================================================================
   b:= bt^2/var1;
   if not has([a, b], var1) then
      if iszero(a) then
        // This is the simplification of the formula for arbitrary a:
        return(exp(-b/4/var2)/var2):
      else
        return(sqrt(PI)*sqrt(b)/4/var2^(3/2)*exp(-b/8/var2)*
                       (besselI(a/2 - 1/2, b/8/var2)
                       -besselI(a/2 + 1/2, b/8/var2)));
      end_if;
   end_if;
   // ===================================================================
   // laplace(besselJ(0, sqrt(a*x^2 + b*x)), x, y) = 
   //     exp(b/2/a*(y - sqrt(y^2 + a))) / sqrt(y^2 + a)
   // ===================================================================
   if iszero(a) then
      b:= poly(bt^2, [var1]);
      if (not has(b, FAIL)) and
         degree(b) = 2 and
         iszero(coeff(b, 0)) then
         [a, b]:= [coeff(b, 2), coeff(b, 1)];
         if (not has([a, b], var1)) and
            (not iszero(a)) then
           return(exp(b/2/a*(var2 - sqrt(var2^2 + a))) / sqrt(var2^2 + a)):
         end_if;
      end_if;
   end_if;
   FAIL;
  end_proc:
