// Dirk Mueller, olorien, 28/10/96, v1.0 

cosh::"transform::laplace":=
  proc(_f, var1, var2) 
    local _a, _b, ana, _g;
  begin
    _g:=expand(op(_f));
    _a:=normal(_g/var1);
    if not has(_a, var1) then
      userinfo(10, "formula 14 from Heuser");
      return(var2/(var2^2-_a^2))
    else
      if testtype(_g, Type::RatExpr(var1)) then
        ana:=transform::IntTrans::anapol(_g, var1);
        case ana[1][1]
        of [1,3] do
          _a:=ana[2][1][2]; _b:=ana[2][1][1];
          userinfo(10, "formula from M&P");
          return( 1/2*( exp(-_b)*(var2-_a)+exp(_b)*(_a+var2) )/(var2^2-_a^2) );
        end_case;
      end_if;
    end_if;
    FAIL;
  end_proc:

// end of file 
