// Dirk Mueller, olorien, 28/10/96, v1.0 

dirac::"transform::laplace":=
  proc(_f, var1, var2) 
    local _a, _g, erg, _k;
  begin
    // ---------------------------------
    // Stephan Jan.2.2002
    // laplace(dirac(a*x), x, s) = 1/abs(a)
    // laplace(dirac(x - a), x, s) = exp(-as)
    // laplace(dirac(a*x, k), x, s) = (s/a)^k * 1/abs(a) (k-th derivative of dirac)
    // laplace(dirac(x - a, k), x, s) = s^k exp(-sa) (k-th derivative of dirac)
    
    _g:=op(_f, 1);
    if nops(_f) = 2 then 
	_k := op(_f, 2);
    else 
	_k := 0;
    end_if;
    _a:=normal(_g/var1);
    if not has(_a, var1) then
      userinfo(10, "formula from M&P");
      return((var2/_a)^_k *1/abs(_a));
    end_if;

    _a:=normal(-(_g-var1));
    if not has(_a, var1) then
      erg:=is(_a>0);
      if erg=TRUE then
        userinfo(10, "formula 1.1 from R&K");
        return(var2^_k * exp(-_a*var2));
      elif erg=FALSE then
        return(0);
      else 
        userinfo(1, "please specify constant "._a);
      end_if;
    end_if;

    FAIL;
  end_proc:


// end of file 
