// Dirk Mueller, olorien, 28/10/96, v1.0 
// Rewritten by Walter, 15.4.2010, for R2011a

int::"transform::laplace" :=
  proc(f, var1, var2) 
    local integrand, intrange, intvar, u, v, dummy, d;
  begin
    if type(f) <> "int" then 
       return(FAIL);
    end_if:
    integrand:=op(f,1); 
    intrange:=op(f,2);
    if type(intrange) <> "_equal" then
       return(FAIL):
    end_if;
    intvar:= op(intrange, 1);
    intrange:= op(intrange, 2);
    if has(op(intrange, 1), var1) then
       if has(op(intrange, 2), var1) then
          return(FAIL);
       else
          integrand:= -integrand;
          intrange:= op(intrange, 2) .. op(intrange, 1);
       end_if;
    end_if;
    if op(intrange,2) <> var1 then
       return(FAIL):
    end_if:
    // compute laplace(int(F(x, y), y = a..x), x, s):
    if has(integrand, var1) then
       //======================================
       // the convolution formula:
       // laplace(int(u(y)*v(x-y), y=0..x),x,s)
       // = laplace(u(x),x,s)*laplace(v(x),x,s)
       // In particular, for v(x-y) = 1 this yields
       // laplace(int(u(y), y=0..x),x,s)
       //      = laplace(u(x),x,s)/s;
       //======================================
       if type(integrand) = "_mult" then
          [v, u, dummy]:= split(integrand, has, var1); 
       else 
          [v, u]:= [integrand, 1];
       end_if;
    else // has(integrand, var1) = FALSE
       [v, u]:= [1, integrand];
    end_if;
    assert(integrand = v*u):
    // test, whether v(x, y) = V(x - y):
    v:= subs(v, var1 = var1 + intvar, EvalChanges);
    if not has(normal(v), intvar) then
       u:= subs(u, intvar = var1):
       // split int(F(y), y = a..x) = int(F(y),y=a..0)+int(F(y),0..x) 
       if iszero(op(intrange, 1)) then
         d:= 0:
       elif is(op(intrange, 1) <= 0) = TRUE then 
         d:= int(transform::laplace(integrand, var1, var2), intvar = op(intrange, 1) .. 0):
       else
         d:=-int(transform::laplace(integrand, var1, var2), intvar = 0..op(intrange, 1)):
       end_if:
       return(d + transform::laplace(u, var1, var2)*
                  transform::laplace(v, var1, var2));
    end_if:
    // v(x, y) is not of the form V(x-y)
    return(FAIL):
  end_proc:
