// Dirk Mueller, olorien, 30/10/96, v1.0 

// heavily reformed by S.H. 9/2002

_mult::"transform::laplace":=
proc(_fu, var1, var2) 
    local ana, ana_args, rat, nonrat, nonrat_types, m, i, j, k, match_list, exps,
         _g, test, trafo, _c, pos, L2, the_end, _n, _m, this_op,
         Num, Den, _lin, Num_sp, Den_sp, Den_L, Den_code, Num_code,
         rat_code, nonrat_code, nonrat_pat, Den_nmb, Num_pat,
         _a, _b, _d, _k, erg1, erg2, branch, bol1, bol2;
begin
 
  Num:=numer(_fu); 
  if type(Num)="_mult" then
    _lin:=select(Num, not has, var1);
    Num:=Num/_lin;
  elif not has(Num, var1) then
    _lin:=Num; Num:=1;
  else
    _lin:=1;
  end_if;

  Den:=denom(_fu); 
  if type(Den) = "exp" then
    [Num, Den]:= [Num/Den, 1];
  elif type(Den)="_mult" then
    // move exponentials from the denominator to the numerator
    [exps, Den]:= split(Den, testtype, "exp")[1..2];
    Num:= Num/exps;
  end_if;

  Num_sp:=[transform::IntTrans::mult_split(Num, var1)];
  Den_sp:=[transform::IntTrans::mult_split(Den, var1)];

  if Den<>1 then 
     Den_L:=transform::IntTrans::anapol(Den, var1);
     if Den_L = FAIL then return(FAIL) end_if;
     Den_code:={op(Den_L[1])}; Den_nmb:=nops(Den_L[1]);
  end_if;

  if Num_sp[1]=1 and Den_sp[2]=1 then // NonRat / Rat 
     Num_code:=transform::IntTrans::nonrat_ana(Num, var1);
     if Num_code = FAIL then return(FAIL) end_if;
     Num_pat:=[Num_code[1], Num_code[2], Num_code[3]];
     if Den<>1 then 
        case Den_code
        of {[1, 2]} do        // Rat is now just const*_var1
          case Num_pat
          of ["_plus", ["exp", "exp"], [1,1]] do
             _a := Num_code[5][1];
             _b := Num_code[5][2];
             _d := Num_code[4][1]/var1;
             _k := Num_code[4][2]/var1;
             if iszero(_a + _b) and not has(_d, var1) and not has(_k, var1) then
                // case NonRat = _a*exp(_d*var1) + _b*exp(_k*var1)
                // laplace transform exists of and only if
                // a = -b and Re(d), Re(k) < Re(var1)
                if testtype(_d, Type::Numeric) and
                   testtype(_k, Type::Numeric) and
                   testtype(var2, Type::Numeric) then
                   if Re(_d) < Re(var2) and
                      Re(_k) < Re(var2) then
                      return(  _lin*_a*(ln((var2-_k)/(var2-_d)))   );
                   else 
                      return(hold(transform::laplace)(_fu, var1, var2));
                end_if;
             else // at least one of _d, _k and var2 is non-numeric
                if testtype(var2, Type::Numeric) then
                   if testtype(_d, Type::Numeric) then
                      if Re(_d) < Re(var2) then
                         bol1:=is(Re(_k) < Re(var2)); // _k is non-numeric
                         if bol1 = FALSE then
                            return(hold(transform::laplace)(_fu, var1, var2));
                         else  // bol1 = TRUE or UNKNOWN
                            return(  _lin*_a*( ln( (var2-_k)/(var2-_d) ) )  );
                         end_if;
                      else
                         return(hold(transform::laplace)(_fu, var1, var2));
                      end_if;
                   else // _d is non-numeric
                       if testtype(_k, Type::Numeric) then
                          if Re(_k) < Re(var2) then
                             bol1:=is(Re(_d) < Re(var2)); 
                             if bol1 = FALSE then 
                                return(hold(transform::laplace)(_fu, var1, var2));
                             else
                                return(  _lin*_a*( ln( (var2-_k)/(var2-_d) ) )  );
                             end_if;
                          else // bol1 = TRUE or UNKNOWN
                             return(hold(transform::laplace)(_fu, var1, var2));
                          end_if;
                       else // _d and _k are non-numeric
                          bol1:=is(Re(_d)<Re(var2));   
                          bol2:=is(Re(_k)<Re(var2));   
                          if (bol1 and bol2) = FALSE then 
                             return(hold(transform::laplace)(_fu, var1, var2));
                          else // bol1 = TRUE or UNKNOWN
                             return(  _lin*_a*( ln( (var2-_k)/(var2-_d) ) )  );
                          end_if;
                       end_if;
                   end_if;
                else // var2 is non-numeric
                   bol1:=is(Re(_d)<Re(var2));   
                   bol2:=is(Re(_k)<Re(var2));   
                   if (bol1 and bol2) = FALSE then 
                      return(hold(transform::laplace)(_fu, var1, var2));
                   else
                      return(  _lin*_a*( ln( (var2-_k)/(var2-_d) ) )  );
                   end_if;
                end_if;
             end_if;  // of this special type
          end_if;
          break;

        of ["_plus", ["RAT","cos"], [1, 1]] do
          if Num_code[4][1]=1 then
            _a:=Num_code[4][2]/var1;
            _b:=Num_code[5][1];
            _d:=Num_code[5][2];          // S.H: _fu := _b*(1-cos(_a*var1))/var1
            if not has(_a, var1) then 
               if iszero(_b + _d) then // bugfix S.H. Sept. 2002
                  userinfo(10, "formula 5.31 from R&K");
                  return(_lin*_b*(1/2*ln(var2^2+_a^2)-ln(var2) ) );
               end_if;
            end_if;
          end_if;
          break;
        end_case; // [Num_code] 
        break;
      end_case: // Den_code 

     // want to do some subcases of the case
     // Den = Rat = (_a*_var1)^_n where stdlib::hasmsign(_n)=FALSE 
     // right here
     if Den <> 1 and Den_nmb = 1  and op(Den_code,1)[2] = 2 then
       // _n:=-Den_L[3][1][1];
       case Num_pat
       of ["_mult", ["exp"], [1] ] do
           this_op:=Num_code[4][1];          //  NonRat = exp(this_op)
           if testtype(this_op, Type::RatExpr(var1) ) then
              _c:=this_op*var1;
              if not has( _c, var1) then
                 _n:=-Den_L[3][1][1];    
                 _a:=Den_L[2][1][2];    // can't be 1/0 can't it?
                 // _fu = (_a*var1)^(_n)*exp(_c/var1) 
                 return(_lin*transform::laplace::compute_x_n_exp_c_over_x(_a,_n,_c,Num/Den, var1, var2));
              end_if;
           end_if;
       end_case;
     end_if;
   else     // Now Den = 1

      Num_code:=transform::IntTrans::nonrat_ana(Num, var1);
      if Num_code = FAIL then return(FAIL) end_if;

      Num_pat:=[Num_code[1], Num_code[2], Num_code[3]];

      case Num_pat
      of ["_mult", ["Ei", "exp"], [1, 1]] do
        _c:=Num_code[4][1]/var1;

        if not has(_c, var1) then
          if testtype(Num_code[4][2], Type::RatExpr(var1)) then
            ana:=transform::IntTrans::anapol(Num_code[4][2], var1);
            if ana = FAIL then return(FAIL) end_if;
            case ana[1][1]
            of [1,3] do   // S.H. 9/2002: 
                 // now _fu = exp(_a*var1+_b)*Ei(_c*var1)
              _a:=ana[2][1][2]; _b:=ana[2][1][1];
              return( _lin*exp(_b)*ln((var2+_c-_a)/_c)/(var2-_a)  );
            end_case;
          end_if;
        end_if;
      end_case; // Num_code 
     
    end_if;     // Den = 1 or <>1

  elif Den=1 then   // no longer NonRat/Rat
/*      case Num_pat
        of ["_mult", ["Ei", "exp"], [1, 1]] do
        _c:=Num_code[4][1]/var1;

        if not has(_c, var1) then
          if testtype(Num_code[4][2], Type::RatExpr(var1)) then
            ana:=transform::IntTrans::anapol(op(op(Num,2)),var1);
            if ana = FAIL then return(FAIL) end_if;
            case ana[1][1]
            of [1,3] do   // S.H. 9/2002: 
                 // now _fu = exp(_a*var1+_b)*Ei(_c*var1)
              _a:=ana[2][1][2]; _b:=ana[2][1][1];
              return( _lin*exp(_b)*ln((var2+_c-_a)/_c)/(var2-_a)  );
            end_case;
          end_if;
        end_if;
      end_case; // Num_pat
*/


 // S.H. 9/2002: _fu =
//  if Den=1 then    // S.H. 9/2002: _fu =
               // Rat/Nonrat or Rat/Rat or NonRat/NonRat
               // Rat*NonRat/Rat or Rat*NonRat/NonRat or
               // Rat/NonRat/Rat or Rat*NonRat/Rat/NonRat
               // because of Den = 1 we have 
               //_fu = Rat or _fu = Rat * NonRat (neither is trivial)
    rat_code:=transform::IntTrans::anapol(Num_sp[1], var1);
    if rat_code = FAIL then return(FAIL) end_if;  // S.H:  should never happen
    nonrat_code:=transform::IntTrans::nonrat_ana(Num_sp[2], var1);
    if domtype(nonrat_code) <> DOM_LIST
       or nops(nonrat_code) < 3 then 
       return(FAIL)                      // S.H: should never happen
    end_if;
    nonrat_pat:=[nonrat_code[1], nonrat_code[2], nonrat_code[3]];

    if nonrat_pat=["_mult", ["exp"], [1] ] then   
      this_op:=nonrat_code[4][1];          // S.H.: NonRat = exp(this_op)
      if testtype(this_op, Type::RatExpr(var1) ) then
      _c:=this_op*var1;
        if not has( _c, var1) then
          if rat_code[1][1][2]=2 then // Rat = (_a*var1)^_n
            _n:=rat_code[3][1][1];    // S.H.: 9/2002
                          // _fu = var1^_n*exp(-_c/var1)
            _a:=rat_code[2][1][2];    // S.H. bugfix, get the coefficient
            return(_lin*transform::laplace::compute_x_n_exp_c_over_x(_a,_n,_c,Num/Den, var1, var2));
          end_if;
        end_if;
      end_if;
    end_if;
  end_if;  // NonRat/Rat


     // now let's try some cases Rat*NonRat/Rat
     // S.H. 9/2002
     // Den = Rat = (_a*_var1)^_n where stdlib::hasmsign(_n)
     // and Num =(_a*_var1)^_m * exp(_c/var1),  stdlib::hasmsign(_m)=FALSE 

  if Den <> 1 and Den_nmb = 1  and op(Den_code,1)[2] = 2 then
     _n:=Den_L[3][1][1];

         rat_code:=transform::IntTrans::anapol(Num_sp[1], var1);
         if rat_code = FAIL then return(FAIL) end_if;  //should never happen
         nonrat_code:=transform::IntTrans::nonrat_ana(Num_sp[2], var1);
     if domtype(nonrat_code) <> DOM_LIST
            or nops(nonrat_code) < 3 then 
                 return(FAIL)                      //should never happen
         end_if;
         nonrat_pat:=[nonrat_code[1], nonrat_code[2], nonrat_code[3]];

         if nonrat_pat=["_mult", ["exp"], [1] ] then   
                this_op:=nonrat_code[4][1];          // NonRat = exp(this_op)
                if testtype(this_op, Type::RatExpr(var1) ) then
            _c:=this_op*var1;
               if not has( _c, var1) then
                  if rat_code[1][1][2]=2 then // Rat = (_a*var1)^_n
                      _m:=rat_code[3][1][1];  
                               // _fu = var1^_n*exp(-_c/var1)
                _a:=rat_code[2][1][2];    //  get the coefficient
                     return(_lin*transform::laplace::compute_x_n_exp_c_over_x(_a,_m-_n,_c,
                                                            Num/Den, var1, var2));
                  end_if;
              end_if;
        end_if;
          end_if;
  //    end_if;
  end_if;

  ana:=[transform::IntTrans::mult_split(_fu, var1)];

  rat:=ana[1]; 
  nonrat:=ana[2]; 

  // mult_split might have transformed (a*var1)^b*sin(..)
  // into a^b*var1^b*sin(..). Get rid of constant factors:
  if type(rat) = "_mult" then
     [rat, _lin]:= split(rat, has, var1)[1..2];
     if not iszero(_lin - 1) then
        return(_lin * transform::laplace(rat*nonrat, var1, var2));
     end_if;
  end_if;

  match_list:=["heaviside", "exp", "sinh", "cosh", "sin", "cos"];

  test:=transform::IntTrans::anapol(rat, var1);
  if test = FAIL then return(FAIL) end_if;
            // S.H. 9/2002 now we're again in case
            // Polynomial * NonRat (NonRat = 1 is possible)
            // here Polynomial can have exponents of
            // any complex numbers ....
  if test[1][1][2]=2 then    // Polynomial = t^n * Polynomial
                // or         = Polynomial * t^n

    //--------------------------------------------------------------
    // Walter, 27.11.00:
    // I assume that this is the case laplace(x^n*nonrat(x), x, s).
    // However, the matcher seems to be buggy. With
    // laplace(x^2*(x-1),x,s) we end up here with rat=x^2*(x-1)
    // and nonrat = 1. So, as a crude hack, I expand rat
    // and return the transform term by term:
    if type(expand(rat))="_plus" then
       rat:= expand(rat);
       return(
              _plus(transform::laplace(op(rat, k)*nonrat, var1, var2)
                $ k = 1..nops(rat)
              )
             );
    end_if;
    if type(rat) = "_mult" then // e.g., for rat = x*x^a
       return(FAIL)
    end_if;

    // now, I can assume rat = var1^(_n)
    //--------------------------------------------------------------

    _n:=test[3][1][1];
    if is(_n>0)=TRUE then
      trafo:=(transform::laplace)(nonrat, var1, var2);
      userinfo(10, "power modulation");
      if not hastype(trafo, "transform::laplace")
        then
          // if domtype(_n) = DOM_INT inserted (Walter, 27.11.00)
          // Before, transform::laplace(x^(3/2)*(x-1), x, s) arrived
          // here with _n = 3/2 and produced an error in k=1.._n
          // This is just a crude hack to prevent wrong results!
          // The symbolic answer transform::laplace(x^(3/2)*(x-1), x, s)
          // that we get now is not satisfactory!
          if domtype(_n) = DOM_INT 
      // only differentiate when var2 is a variable (S.H. Jun.4.2002)
      and domtype(var2) = DOM_IDENT
      then 
             return( (-1)^_n*diff(trafo, var2 $ k=1.._n) );
          end_if;
      end_if;
/*
    elif is(_n<0) then
      return(FAIL);
*/
    end_if;
  end_if;

  if type(nonrat)<>"_mult" then
    nonrat_types:=[type(nonrat)];
  else
    nonrat_types:=[map(op(nonrat), type)];
  end_if;

  m:=nops(nonrat_types);

  for i from 1 to nops(match_list) do
    pos:=0: 
    L2:=[ (pos:=contains(nonrat_types, match_list[i], pos+1)) 
                $ k=1..nops(nonrat_types),0  ];

    the_end:=contains(L2, 0);

    for j from 1 to the_end-1 do
     if type(nonrat)="_mult" then
       test:=op(op(nonrat, L2[j]));
     else
       test:=op(nonrat);
     end_if;

      if testtype(test, Type::RatExpr(var1)) then
        ana_args:=transform::IntTrans::anapol(test, var1);
        if ana_args = FAIL then return(FAIL) end_if;
        if nops(ana_args[2][1]) > 1 then
           _c:=ana_args[2][1][2];
        else
           return(FAIL);
        end_if:

        if m=1 then
          _g:=rat;
        else
          _g:=subsop(nonrat, L2[j]=1)*rat;
        end_if;

        if ana_args[1][1]=[1,2] then

// ---------------- by Stephan Huckemann, may 2002 ------------------
//    we are now in case rational(x) * function(x)
//    we'll single out the case rational(x) = (_d * x)^k
//    and give it an extra treat
//    hopefully that we can rely on the function anapol ...
//    
    ana := transform::IntTrans::anapol(_g, var1);
    if nops(ana[1]) = 1 and     // only 1 polynomial 
        ana[1][1][2] = 2 then   // with all coeff = 0 save for the linear coeff. <> 0
        _d := ana[2][1][2];     // that's the linear coeff
        _k := ana[3][1][1];     // the power
    else
        _d := 0;
    end_if;


        case nonrat_types[L2[j]] 
        of "exp" do
           userinfo(10, "exp-modulation");
           return((transform::laplace)(_g, var1, var2-_c));

        of "sin" do
           if not iszero(_d) then
             return(transform::laplace::compute_x_n_sin_x(_d,_k,_c, var1, var2));
           end_if;
           // Walter 29.1.06: re-activated the following lines
           trafo:=(transform::laplace)(_g, var1, var2); 
           userinfo(10, "sin-modulation");
           erg1:= normal(1/(2*I)*(subsex(trafo, var2=var2-I*_c)-
                                  subsex(trafo, var2=var2+I*_c)),
                         Expand = FALSE):
           if has(erg1, I) then 
              // normalize again with Expand = TRUE, since this
              // will simplify 1/(s+I)/(s-I) to 1/(s^2 + 1)
              erg1:= normal(erg1, Expand = TRUE);
           end_if;
           return(erg1);

        of "cos" do
           if not iszero(_d) then
              return(transform::laplace::compute_x_n_cos_x(_d,_k,_c, var1, var2));
           end_if;
           trafo:=(transform::laplace)(_g, var1, var2); 
           userinfo(10, "cos-modulation");
           erg1:= normal(1/2*(subsex(trafo, var2=var2-I*_c)+
                              subsex(trafo, var2=var2+I*_c)),
                         Expand = FALSE);
           if has(erg1, I) then 
              // normalize again with Expand = TRUE, since this
              // will simplify 1/(s+I)/(s-I) to 1/(s^2 + 1)
              erg1:= normal(erg1, Expand = TRUE);
           end_if;
           return(erg1);

        of "sinh" do // ------ by Stephan Huckemann, may 2002 --------
        if not iszero(_d) then
          case _k
          of -1 do
        return(1/2*ln((_c + var2)/(var2 - _c))/_d);
          of -1/2 do
        // pick the correct branch of the root
        branch := 0;
            // -PI/4 < arg(_c) <= PI/4
        if  is(Re(_c) > 0) = TRUE and
            ( (is(Im(_c) >= 0) = TRUE and is(Im(_c) <= Re(_c)) = TRUE) or
              (is(Im(_c) < 0) = TRUE and is(-Im(_c) < Re(_c)) = TRUE) 
            )    then
            branch :=1;
        elif    // 3 PI/4 < arg(_c) <= 5 PI/4
              is(Re(_c) < 0) = TRUE and 
            ( (is(Im(_c) >= 0) = TRUE and is(Im(_c) < -Re(_c)) = TRUE) or
              (is(Im(_c) < 0) = TRUE and is(-Im(_c) <= -Re(_c))= TRUE) 
            ) then
            branch :=-1;
        end_if;
        if iszero(branch) then
              erg1 := sqrt(var2 + _c); // var2 must be restricted such that
              erg2 := sqrt(var2 - _c); // both ly in the right half-plane
              branch := sign(Re(erg1 - erg2)) + (1 - abs(sign(Re(erg1 - erg2))))
                            * sign(Im(erg1 - erg2));
        end_if;
        if not iszero(branch) and testtype(branch, Type::Numeric) then
                  return(branch * (var2 - sqrt(var2^2 - _c^2))^(1/2)
                  /sqrt(var2^2 -_c^2)*_d^_k*sqrt(PI/2));
        end_if; 
        break;
          of -3/2 do    // pick the correct branch of the root
        branch := 0;
            // -PI/4 < arg(_c) <= PI/4
        if  is(Re(_c) > 0) = TRUE and
            ( (is(Im(_c) >= 0) = TRUE and is(Im(_c) <= Re(_c)) = TRUE) or
              (is(Im(_c) < 0) = TRUE and is(-Im(_c) < Re(_c)) = TRUE) 
            )    then
            branch :=1;
        elif    // 3 PI/4 < arg(_c) <= 5 PI/4
              is(Re(_c) < 0) = TRUE and 
            ( (is(Im(_c) >= 0) = TRUE and is(Im(_c) < -Re(_c)) = TRUE) or
              (is(Im(_c) < 0) = TRUE and is(-Im(_c) <= -Re(_c))= TRUE) 
            ) then
            branch :=-1;
        end_if;
        if iszero(branch) then
              erg1 := sqrt(var2 + _c); // var2 must be restricted such that
              erg2 := sqrt(var2 - _c); // both ly in the right half-plane
              branch := sign(Re(erg1 - erg2)) + (1 - abs(sign(Re(erg1 - erg2))))
                            * sign(Im(erg1 - erg2));
        end_if;
        if not iszero(branch) and testtype(branch, Type::Numeric) then
            return(branch* (var2 - sqrt(var2^2 - _c^2))^(1/2)*_d^_k*sqrt(2*PI));
        end_if;
        break;
          otherwise
        if (testtype(_k, Type::Numeric) and (is(Re(_k) > -2) = TRUE))
            // case _k = integer is already covered somewhere else
            or // symbolic and assumption
            (not testtype(_k, Type::Numeric) and (is(Re(_k) > -2) = TRUE)) then    
                  return(gamma(_k+1)/2*
                ((var2 - _c)^(-(_k+1)) - (var2 + _c)^(-(_k+1)) )
                    *_d^_k);
        end_if;
          end_case;
        end_if;

            // in cases _k = -1/2, -3/2
            // when the branch of the root cannot be determined
            // we don't return an awful
            // branch := sign(Re(erg1 - erg2)) + (1 - abs(sign(Re(erg1 - erg2))))
            //                    * sign(Im(erg1 - erg2));
            // but just a simpler but likewise unsatisfactory 

            trafo:=(transform::laplace)(_g, var1, var2);
            userinfo(10, "sinh-modulation");
            return( 1/2*(subsex(trafo, var2=var2-_c)-
                         subsex(trafo, var2=var2+_c)));

        of "cosh" do // ---------------- by Stephan Huckemann, may 2002 ------------------
        if not iszero(_d) then
          case _k
          of -1/2 do
        // don't bother about correct branch of the root
        branch := 1;
                  return( branch * (var2 + sqrt(var2^2 - _c^2))^(1/2)
                  /sqrt(var2^2 -_c^2)*_d^_k*sqrt(PI/2));
        break;
          otherwise
        if (testtype(_k, Type::Numeric) and (is(Re(_k) > -1) = TRUE))
            // case _k = integer is already covered somewhere else
            or // symbolic and assumption
            (not testtype(_k, Type::Numeric) and (is(Re(_k) > -1) = TRUE)) then    
                  return( gamma(_k+1)/2*
                ((var2 - _c)^(-(_k+1)) + (var2 + _c)^(-(_k+1))) 
                    *_d^_k);
        end_if;
          end_case;
        end_if;
// ------------------------------------------------------------------
            trafo:=(transform::laplace)(_g, var1, var2); 
            userinfo(10, "cosh-modulation");
            return( 1/2*((transform::laplace)(_g, var1, var2-_c)+
                    (transform::laplace)(_g, var1, var2+_c))
                  );

        of "heaviside" do
            erg1:=is(_c>0);
            if erg1=FALSE then
              userinfo(10, "heaviside modulation, case 1");
              return(0)
            elif erg1=TRUE then
              userinfo(10, "heaviside modulation, case 2");
              return( (transform::laplace)(_g, var1, var2) )
            end_if;
            break;

        end_case;
        elif ana_args[1][1]=[1,3] then
          _d:=ana_args[2][1][1];
          case nonrat_types[L2[j]]
          of "heaviside" do
            erg1:=is(_c>0); erg2:=is(_d>0);
            if erg1=TRUE and erg2=TRUE then
              userinfo(10, "heaviside-modulation, case 3");
              return((transform::laplace)(_g, var1, var2));

            elif erg1=TRUE and erg2=FALSE then
              userinfo(10, "heaviside modulation, case 4");
              return(  exp(_d/_c*var2)*(transform::laplace)
                          (subs(_g,var1=var1-_d/_c), var1, var2));
            elif erg1=FALSE and erg2=TRUE then
              userinfo(10, "heaviside modulation, case 5");
              return(  int(exp(-var2*var1)*_g, var1=0..-_d/_c));
            elif erg1=FALSE and erg2=FALSE then
              userinfo(10, "heaviside modulation, case 6");
              return(0);
            end_if;
            break;
            userinfo(10, "heaviside-modulation");

            return((transform::laplace)(_g, var1, var2-_c));
          end_case;
        end_if;

      end_if;
    end_for;
  end_for;

 
  return(FAIL);

end_proc:

// end of file 
