
// Pref::warnDeadProcEnv(TRUE):
testargs(TRUE):

// Ausfhren in TRANS/ZTRANS um invpatterns.mb zu erzeugen
// patterns for definite summation
//
// patterns for definite summation
//
// global assumptions
// Eingabevariable z
// a, b, c, ..., v, w, x, y sind von z unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted
//

default_assumptions :=
map([a,b,c,d,e,f,g,h,i,j,l,m,n,o,p,q,r,s,t,u,v,w,x,y],
  v -> subs(matchlib::block(not has(`#v`, _X)), `#v`=v)) .
map([`#m`,`#n`,`#m0`,`#n0`,`#m1`,`#m2`,`#n1`,`#n2`],
  v -> subs(matchlib::block(testtype(`#v`, Type::PosInt)), `#v`=v)).
[matchlib::block(testtype(`#m2`, Type::Even)),
 matchlib::block(testtype(`#n2`, Type::Even)),
 matchlib::block(testtype(`#m1`, Type::Odd)),
 matchlib::block(testtype(`#n1`, Type::Odd)),
 matchlib::block(testtype(`#n3`, Type::Integer)),
 matchlib::block(testtype(`#m3`, Type::Integer)),
 null()
]:

assumptions :=
proc(pattern)
  local vars;
begin
  vars := indets(pattern) union Type::ConstantIdents union stdlib::PROTECTED union {_X, _Y, `#matchlib::block`};
  select(default_assumptions,
         a->indets(a) minus vars = {});
end:

include_assumptions :=
proc(p)
begin
  [p[1], p[2],
//   [op(indets(p) minus (Type::ConstantIdents union stdlib::PROTECTED union {_X, _Y, `#matchlib::block`}))],
   if nops(p) = 3 then
     p[3]
   else
     []
   end_if,
   assumptions(p[1])];
end_proc:

// here, the vars have not been renamed yet
extractconstants :=
proc(pat)
  local pat1, noX, dummy;
begin
  if type(pat[1]) = "_mult" then
    [pat1, noX, dummy] := split([op(pat[1])],
                                has, hold([z, fx, gx, f1x, g1x, px, qx, qx1]));
    noX := _mult(op(noX));
    if noX <> 1 then
      [_mult(op(pat1)),
       subs(matchlib::block(`#a`/`#b`),
            `#a`=matchlib::unblock(pat[2]),
            `#b`=noX),
       if nops(pat)>2 then
         pat[3]
       else
         null()
       end_if];
    else
      pat;
    end_if;
  else
    pat
  end_if;
end_proc:

LEVEL := 1: // spart Zeit beim Einlesen

START := time():

read("invpatterns.mu"):

// check for errors happening often:
for pat in invztrans_patterns do
  if domtype(pat) <> DOM_LIST then
    error("Not a list: ".expr2text(pat));
  end_if;
  if nops(pat) > 3 then
    if domtype(pat[3]) <> DOM_LIST then
      error("illegal conditions at ".expr2text(pat[1]));
    end_if;
  end_if;
end_for:

// constant factors
ztrans_patterns2 := subs(map(invztrans_patterns,
                             extractconstants), [z=_X, k=_Y]):

// for userinfo
//fourier_patterns2 := transform::fourier::addpattern::addcomments(fourier_patterns2):

if FALSE then
// debugging help
for i from 1 to nops(ztrans_patterns2) do
  ztrans_patterns2[i][2] := ztrans_patterns2[i][2]*(`#pattern`.i);
end_for:
end_if:

print(Unquoted,
      _outputSequence(nops(ztrans_patterns2),
                      " patterns read in ",
                      (time()-START)/1000.0, " seconds")):

ztrans_patterns2 := map(ztrans_patterns2, include_assumptions):

allpatterns := []:

if nops(ztrans_patterns2) > 0 then
/*
  matchlib::addpatterns(transform::invztrans::patternFSA, allpatterns, ztrans_patterns2,
    	                  transform::invztrans::addpattern::generalizesum, FALSE, FAIL); 
*/
  sysassign(transform::invztrans::patterns,matchlib::einwohner::compile(ztrans_patterns2,_X)); 
else
  sysassign(transform::invztrans::patterns, FAIL);
end_if:

print(Unquoted,
      _outputSequence("compilation finished, ", (time()-START)/1000.0, " seconds")):
               
bytes();

if doNotSavePatterns <> TRUE then
  invpatterns := transform::invztrans::patterns;
  write("invpatterns.mb", invpatterns);
end_if:

