transform::invztrans::lookup:=
proc(f : Type::Arithmetical, x : DOM_IDENT)
  save _X;
  local C, F, noX, dummy;
begin
  C:=genident();

  if x <> _X then
    delete _X;
    /* The summation index does not have properties
    if property::hasprop(x) then
      //assume(_X,prop) // doesn't work due to an error in assume
      zip([_X],[getprop(x)],assume);
    end_if;
    */
    if x<>_X then f:=subs(f,[_X=C,x=_X],EvalChanges) end_if;
  elif _X <> hold(_X) then
    delete _X;
  end_if;
  //  remove independent factors
  if type(f)="_mult" then
    [f, noX, dummy] := split([op(f)], has, _X);
    assert(dummy = []);
    f := _mult(op(f));
    noX := _mult(op(noX));
  else
    noX := 1;
  end_if;
  
  F := FAIL;

  if transform::invztrans::userpatternsFSA <> FAIL then
      F := matchlib::addpatterns::handle_results(
                  matchlib::evalFSA(f, transform::invztrans::userpatternsFSA));
  end_if;

  if F = FAIL then
    if transform::invztrans::patterns <> FAIL then
        F := matchlib::addpatterns::handle_results(
                    matchlib::einwohner(f, _X, op(transform::invztrans::patterns), {_Y}));
    end_if;
  end_if;
  
  if F<>FAIL then F:=subs(noX * F, [_X=x,C=_X]) end_if;
  F
end_proc:


//--------------------------------------------------
// utility for the pattern 
// invztrans((a*z + b)/(c*z^2 + d*z + e), z, k)
// --> lookup_f1(k, a, b, c, d, e)
//--------------------------------------------------
transform::invztrans::lookup_f1:= proc(k, a, b, c, d, e)
local f, dd, dummy;
begin
   if iszero(c) or
      iszero(d) or
      iszero(e) then
      return(FAIL);
   end_if;

   if type(d) = "_mult" then

      //----------------------------------------------
      // pattern (a*z + b)/(c*z^2 + 2*dd*cos(f)*z + e) 
      //----------------------------------------------
      [f, dd, dummy]:= split(d, x -> type(x) = "cos");
      dd:= dd/2;
      if type(f) = "cos" and e*c = dd^2 then
         f:= op(f);
         // d = 2*dd*cos(f)
         return(a/cos(f) * cos(k*f)*e^k/(-dd)^(k+1)
              + (a*e - b*dd*cos(f))/dd^2*sin(k*f)/sin(f)*(-dd)^(k-1)/c^(k-1)
              - (a*e - b*dd*cos(f))/dd^2*cos(k*f)/cos(f)*(-dd)^(k-1)/c^(k-1)
              + b/e*kroneckerDelta(k, 0)
         );
      end_if:

      //----------------------------------------------
      // pattern (a*z + b)/(c*z^2 + 2*dd*sin(f)*z + e) 
      //----------------------------------------------
      // Note (sin(f)+I*cos(f))^k =  -I^(k+1)*(sin(k*f)+I*cos(k*f));
      [f, dd, dummy]:= split(d, x -> type(x) = "sin");
      dd:= dd/2;
      if type(f) = "sin" and e*c = dd^2 then
         f:= op(f);
         // d = 2*dd*sin(f)
         return(a/sin(f) * cos(k*(f - PI/2))*e^k/(-dd)^(k+1)
              -  (a*e - b*dd*sin(f))/dd^2*sin(k*(f - PI/2))/cos(f)*(-dd)^(k-1)/c^(k-1)
              -  (a*e - b*dd*sin(f))/dd^2*cos(k*(f - PI/2))/sin(f)*(-dd)^(k-1)/c^(k-1)
              + b/e*kroneckerDelta(k, 0)
         );
      end_if:

      //----------------------------------------------
      // pattern (a*z + b)/(c*z^2 + 2*dd*cosh(f)*z + e) 
      //----------------------------------------------
      [f, dd, dummy]:= split(d, x -> type(x) = "cosh");
      dd:= dd/2;
      if type(f) = "cosh" and e*c = dd^2 then
         f:= op(f);
         // d = 2*dd*cosh(f)
         return( 
                a/cosh(f) * cosh(k*f)*e^k/(-dd)^(k+1)
              + (a*e - b*dd*cosh(f))/dd^2*sinh(k*f)/sinh(f)*(-dd)^(k-1)/c^(k-1)
              - (a*e - b*dd*cosh(f))/dd^2*cosh(k*f)/cosh(f)*(-dd)^(k-1)/c^(k-1)
              + b/e*kroneckerDelta(k, 0)
         );
      end_if;

      //----------------------------------------------
      // pattern (a*z + b)/(c*z^2 + 2*dd*sinh(f)*z + e) 
      //----------------------------------------------
      [f, dd, dummy]:= split(d, x -> type(x) = "sinh");
      dd:= dd/2/I;
      if type(f) = "sinh" and e*c = dd^2 then
         f:= op(f);
         // d = 2*dd*I*sinh(f)
      return(- a/dd/I/sinh(f)*cosh(k*(f + PI/2*I))*e^k/(-dd)^k
             + (a*e-b*I*dd*sinh(f))*( I*dd)^(k-1)/2/dd^2/sinh(f)/cosh(f)*exp(-(k-1)*f)/c^(k-1)
             - (a*e-b*I*dd*sinh(f))*(-I*dd)^(k-1)/2/dd^2/sinh(f)/cosh(f)*exp( (k-1)*f)/c^(k-1)
             + b/e*kroneckerDelta(k, 0)
     );
      end_if;
   end_if;

   //----------------------------------------------------
   // pattern (a*z + b)/(c*z^2 + d*z + e), generic result
   //----------------------------------------------------
   return(
     - 2*(-1)^k*a/d*cos(k*arccos(d/2/sqrt(c*e)))*e^k/sqrt(c*e)^k
     + (a*e-b*d/2)*(-1)^k/d/sqrt(d^2/4-c*e)*(d/2-sqrt(d^2/4-c*e))^(k-1)/c^(k-1)
     - (a*e-b*d/2)*(-1)^k/d/sqrt(d^2/4-c*e)*(d/2+sqrt(d^2/4-c*e))^(k-1)/c^(k-1)
     + b/e*kroneckerDelta(k, 0)
   );
end_proc:
