// Globale Annahmen:
// source variable: z
// target variable: k
// a, b, c, ..., v, w, y sind von z unabhngig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted

// Diese Datei wird aus compile_invpatterns.mu heraus gelesen.

alias(bl=matchlib::block):

invztrans_patterns:=
[
 //----------
 // pattern 0
 //----------
 //----------
 // pattern 1
 //----------
  // It's not a good idea to have constants in the pattern which can and will
 // be eliminated by extractconstants() while compiling the pattern.
 // One should avoid such patterns
 [1/z^d, bl(kroneckerDelta(k, d)), [d in Z_, d >= 0]], 
 //----------
 // pattern 2
 //----------
 [1/(b*z + c)^d, 
    bl(kroneckerDelta(k, 0)/c^d + binomial(k-1, d - 1)*(-c/b)^k/(-c)^d),
    [c <> 0, d in Z_, d >= 0, b <> 0]
  ],
 [1/(b*z + c)^d, 
    bl(1/b^d*kroneckerDelta(k, d)),
    [c = 0, d in Z_, d >= 0, b <> 0]
  ],
 //----------
 // pattern 3
 //----------
 [z/(b*z + c), 1/b*(-c/b)^k],
/*
 //----------
 // pattern 4
 //----------
 [a*z^b, piecewise([b in Z_ and b <= 0, a*kroneckerDelta(k, -b)])],
 [a*z^b, a*kroneckerDelta(k, -b), [b in Z_ and b <= 0]],
*/
 //----------
 // pattern 5
 //----------
 [exp(b/z), b^k/k!],
 [1/exp(b/z), (-b)^k/k!],
 //----------
 // pattern 6a
 //----------
 //---------------------------------------------------------
 // TRANS/ZTRANS/invlookup.mu contains the utility procedure
 // transform::invztrans::lookup_f1 that takes care of the
 // pattern (a*z + b)/(c*z^2 + d*z + e) 
 [(a*z + b)/(c*z^2 + d*z + e), bl(transform::invztrans::lookup_f1(k, a, b, c, d, e))],
 [    1    /(c*z^2 + d*z + e), bl(transform::invztrans::lookup_f1(k, 0, 1, c, d, e))],
 [(a*z - 1)/(z^2 - 2*a*z + 1), cos(k*arccos(a)) - kroneckerDelta(k, 0)],
 [(cos(a)*z - 1)/(z^2 - 2*cos(a)*z + 1), cos(k*a) - kroneckerDelta(k, 0)],
 [z*(z-a)/(z^2 - 2*a*z + 1), cos(k*arccos(a))],
 [(z^2-a*z)/(z^2 - 2*a*z + 1), cos(k*arccos(a))],

 null()
]:
